/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53domains.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The ListOperations response includes the following elements.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListOperationsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<ListOperationsResponse.Builder, ListOperationsResponse> {
    private final List<OperationSummary> operations;

    private final String nextPageMarker;

    private ListOperationsResponse(BuilderImpl builder) {
        this.operations = builder.operations;
        this.nextPageMarker = builder.nextPageMarker;
    }

    /**
     * <p>
     * Lists summaries of the operations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Lists summaries of the operations.
     */
    public List<OperationSummary> operations() {
        return operations;
    }

    /**
     * <p>
     * If there are more operations than you specified for <code>MaxItems</code> in the request, submit another request
     * and include the value of <code>NextPageMarker</code> in the value of <code>Marker</code>.
     * </p>
     * 
     * @return If there are more operations than you specified for <code>MaxItems</code> in the request, submit another
     *         request and include the value of <code>NextPageMarker</code> in the value of <code>Marker</code>.
     */
    public String nextPageMarker() {
        return nextPageMarker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(operations());
        hashCode = 31 * hashCode + Objects.hashCode(nextPageMarker());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOperationsResponse)) {
            return false;
        }
        ListOperationsResponse other = (ListOperationsResponse) obj;
        return Objects.equals(operations(), other.operations()) && Objects.equals(nextPageMarker(), other.nextPageMarker());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (operations() != null) {
            sb.append("Operations: ").append(operations()).append(",");
        }
        if (nextPageMarker() != null) {
            sb.append("NextPageMarker: ").append(nextPageMarker()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Operations":
            return Optional.of(clazz.cast(operations()));
        case "NextPageMarker":
            return Optional.of(clazz.cast(nextPageMarker()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ListOperationsResponse> {
        /**
         * <p>
         * Lists summaries of the operations.
         * </p>
         * 
         * @param operations
         *        Lists summaries of the operations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operations(Collection<OperationSummary> operations);

        /**
         * <p>
         * Lists summaries of the operations.
         * </p>
         * 
         * @param operations
         *        Lists summaries of the operations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operations(OperationSummary... operations);

        /**
         * <p>
         * If there are more operations than you specified for <code>MaxItems</code> in the request, submit another
         * request and include the value of <code>NextPageMarker</code> in the value of <code>Marker</code>.
         * </p>
         * 
         * @param nextPageMarker
         *        If there are more operations than you specified for <code>MaxItems</code> in the request, submit
         *        another request and include the value of <code>NextPageMarker</code> in the value of
         *        <code>Marker</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextPageMarker(String nextPageMarker);
    }

    static final class BuilderImpl implements Builder {
        private List<OperationSummary> operations;

        private String nextPageMarker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListOperationsResponse model) {
            operations(model.operations);
            nextPageMarker(model.nextPageMarker);
        }

        public final Collection<OperationSummary.Builder> getOperations() {
            return operations != null ? operations.stream().map(OperationSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder operations(Collection<OperationSummary> operations) {
            this.operations = OperationSummaryListCopier.copy(operations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operations(OperationSummary... operations) {
            operations(Arrays.asList(operations));
            return this;
        }

        public final void setOperations(Collection<OperationSummary.BuilderImpl> operations) {
            this.operations = OperationSummaryListCopier.copyFromBuilder(operations);
        }

        public final String getNextPageMarker() {
            return nextPageMarker;
        }

        @Override
        public final Builder nextPageMarker(String nextPageMarker) {
            this.nextPageMarker = nextPageMarker;
            return this;
        }

        public final void setNextPageMarker(String nextPageMarker) {
            this.nextPageMarker = nextPageMarker;
        }

        @Override
        public ListOperationsResponse build() {
            return new ListOperationsResponse(this);
        }
    }
}
