/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53domains.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A <code>RenewDomain</code> request includes the number of years that you want to renew for and the current expiration
 * year.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class RenewDomainRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<RenewDomainRequest.Builder, RenewDomainRequest> {
    private final String domainName;

    private final Integer durationInYears;

    private final Integer currentExpiryYear;

    private RenewDomainRequest(BuilderImpl builder) {
        this.domainName = builder.domainName;
        this.durationInYears = builder.durationInYears;
        this.currentExpiryYear = builder.currentExpiryYear;
    }

    /**
     * <p>
     * The name of the domain that you want to renew.
     * </p>
     * 
     * @return The name of the domain that you want to renew.
     */
    public String domainName() {
        return domainName;
    }

    /**
     * <p>
     * The number of years that you want to renew the domain for. The maximum number of years depends on the top-level
     * domain. For the range of valid values for your domain, see <a
     * href="http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You Can
     * Register with Amazon Route 53</a> in the <i>Amazon Route 53 Developer Guide</i>.
     * </p>
     * <p>
     * Default: 1
     * </p>
     * 
     * @return The number of years that you want to renew the domain for. The maximum number of years depends on the
     *         top-level domain. For the range of valid values for your domain, see <a
     *         href="http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You
     *         Can Register with Amazon Route 53</a> in the <i>Amazon Route 53 Developer Guide</i>.</p>
     *         <p>
     *         Default: 1
     */
    public Integer durationInYears() {
        return durationInYears;
    }

    /**
     * <p>
     * The year when the registration for the domain is set to expire. This value must match the current expiration date
     * for the domain.
     * </p>
     * 
     * @return The year when the registration for the domain is set to expire. This value must match the current
     *         expiration date for the domain.
     */
    public Integer currentExpiryYear() {
        return currentExpiryYear;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(durationInYears());
        hashCode = 31 * hashCode + Objects.hashCode(currentExpiryYear());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RenewDomainRequest)) {
            return false;
        }
        RenewDomainRequest other = (RenewDomainRequest) obj;
        return Objects.equals(domainName(), other.domainName()) && Objects.equals(durationInYears(), other.durationInYears())
                && Objects.equals(currentExpiryYear(), other.currentExpiryYear());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (domainName() != null) {
            sb.append("DomainName: ").append(domainName()).append(",");
        }
        if (durationInYears() != null) {
            sb.append("DurationInYears: ").append(durationInYears()).append(",");
        }
        if (currentExpiryYear() != null) {
            sb.append("CurrentExpiryYear: ").append(currentExpiryYear()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainName":
            return Optional.of(clazz.cast(domainName()));
        case "DurationInYears":
            return Optional.of(clazz.cast(durationInYears()));
        case "CurrentExpiryYear":
            return Optional.of(clazz.cast(currentExpiryYear()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, RenewDomainRequest> {
        /**
         * <p>
         * The name of the domain that you want to renew.
         * </p>
         * 
         * @param domainName
         *        The name of the domain that you want to renew.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * The number of years that you want to renew the domain for. The maximum number of years depends on the
         * top-level domain. For the range of valid values for your domain, see <a
         * href="http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You Can
         * Register with Amazon Route 53</a> in the <i>Amazon Route 53 Developer Guide</i>.
         * </p>
         * <p>
         * Default: 1
         * </p>
         * 
         * @param durationInYears
         *        The number of years that you want to renew the domain for. The maximum number of years depends on the
         *        top-level domain. For the range of valid values for your domain, see <a
         *        href="http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that
         *        You Can Register with Amazon Route 53</a> in the <i>Amazon Route 53 Developer Guide</i>.</p>
         *        <p>
         *        Default: 1
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder durationInYears(Integer durationInYears);

        /**
         * <p>
         * The year when the registration for the domain is set to expire. This value must match the current expiration
         * date for the domain.
         * </p>
         * 
         * @param currentExpiryYear
         *        The year when the registration for the domain is set to expire. This value must match the current
         *        expiration date for the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentExpiryYear(Integer currentExpiryYear);
    }

    static final class BuilderImpl implements Builder {
        private String domainName;

        private Integer durationInYears;

        private Integer currentExpiryYear;

        private BuilderImpl() {
        }

        private BuilderImpl(RenewDomainRequest model) {
            domainName(model.domainName);
            durationInYears(model.durationInYears);
            currentExpiryYear(model.currentExpiryYear);
        }

        public final String getDomainName() {
            return domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final Integer getDurationInYears() {
            return durationInYears;
        }

        @Override
        public final Builder durationInYears(Integer durationInYears) {
            this.durationInYears = durationInYears;
            return this;
        }

        public final void setDurationInYears(Integer durationInYears) {
            this.durationInYears = durationInYears;
        }

        public final Integer getCurrentExpiryYear() {
            return currentExpiryYear;
        }

        @Override
        public final Builder currentExpiryYear(Integer currentExpiryYear) {
            this.currentExpiryYear = currentExpiryYear;
            return this;
        }

        public final void setCurrentExpiryYear(Integer currentExpiryYear) {
            this.currentExpiryYear = currentExpiryYear;
        }

        @Override
        public RenewDomainRequest build() {
            return new RenewDomainRequest(this);
        }
    }
}
