/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.route53.model.HostedZoneLimitType;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetHostedZoneLimitRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, GetHostedZoneLimitRequest> {
    private final String type;
    private final String hostedZoneId;

    private GetHostedZoneLimitRequest(BuilderImpl builder) {
        this.type = builder.type;
        this.hostedZoneId = builder.hostedZoneId;
    }

    public HostedZoneLimitType type() {
        return HostedZoneLimitType.fromValue(this.type);
    }

    public String typeString() {
        return this.type;
    }

    public String hostedZoneId() {
        return this.hostedZoneId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostedZoneId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetHostedZoneLimitRequest)) {
            return false;
        }
        GetHostedZoneLimitRequest other = (GetHostedZoneLimitRequest)((Object)obj);
        return Objects.equals(this.typeString(), other.typeString()) && Objects.equals(this.hostedZoneId(), other.hostedZoneId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.typeString() != null) {
            sb.append("Type: ").append(this.typeString()).append(",");
        }
        if (this.hostedZoneId() != null) {
            sb.append("HostedZoneId: ").append(this.hostedZoneId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Type": {
                return Optional.of(clazz.cast(this.typeString()));
            }
            case "HostedZoneId": {
                return Optional.of(clazz.cast(this.hostedZoneId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private String hostedZoneId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetHostedZoneLimitRequest model) {
            this.type(model.type);
            this.hostedZoneId(model.hostedZoneId);
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(HostedZoneLimitType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getHostedZoneId() {
            return this.hostedZoneId;
        }

        @Override
        public final Builder hostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
            return this;
        }

        public final void setHostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
        }

        public GetHostedZoneLimitRequest build() {
            return new GetHostedZoneLimitRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetHostedZoneLimitRequest> {
        public Builder type(String var1);

        public Builder type(HostedZoneLimitType var1);

        public Builder hostedZoneId(String var1);
    }
}

