/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.route53.model.ReusableDelegationSetLimitType;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetReusableDelegationSetLimitRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, GetReusableDelegationSetLimitRequest> {
    private final String type;
    private final String delegationSetId;

    private GetReusableDelegationSetLimitRequest(BuilderImpl builder) {
        this.type = builder.type;
        this.delegationSetId = builder.delegationSetId;
    }

    public ReusableDelegationSetLimitType type() {
        return ReusableDelegationSetLimitType.fromValue(this.type);
    }

    public String typeString() {
        return this.type;
    }

    public String delegationSetId() {
        return this.delegationSetId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.delegationSetId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetReusableDelegationSetLimitRequest)) {
            return false;
        }
        GetReusableDelegationSetLimitRequest other = (GetReusableDelegationSetLimitRequest)((Object)obj);
        return Objects.equals(this.typeString(), other.typeString()) && Objects.equals(this.delegationSetId(), other.delegationSetId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.typeString() != null) {
            sb.append("Type: ").append(this.typeString()).append(",");
        }
        if (this.delegationSetId() != null) {
            sb.append("DelegationSetId: ").append(this.delegationSetId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Type": {
                return Optional.of(clazz.cast(this.typeString()));
            }
            case "DelegationSetId": {
                return Optional.of(clazz.cast(this.delegationSetId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private String delegationSetId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetReusableDelegationSetLimitRequest model) {
            this.type(model.type);
            this.delegationSetId(model.delegationSetId);
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ReusableDelegationSetLimitType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getDelegationSetId() {
            return this.delegationSetId;
        }

        @Override
        public final Builder delegationSetId(String delegationSetId) {
            this.delegationSetId = delegationSetId;
            return this;
        }

        public final void setDelegationSetId(String delegationSetId) {
            this.delegationSetId = delegationSetId;
        }

        public GetReusableDelegationSetLimitRequest build() {
            return new GetReusableDelegationSetLimitRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetReusableDelegationSetLimitRequest> {
        public Builder type(String var1);

        public Builder type(ReusableDelegationSetLimitType var1);

        public Builder delegationSetId(String var1);
    }
}

