/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.route53.Route53Client;
import software.amazon.awssdk.services.route53.model.HostedZone;
import software.amazon.awssdk.services.route53.model.ListHostedZonesRequest;
import software.amazon.awssdk.services.route53.model.ListHostedZonesResponse;

public final class ListHostedZonesPaginator
implements SdkIterable<ListHostedZonesResponse> {
    private final Route53Client client;
    private final ListHostedZonesRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListHostedZonesPaginator(Route53Client client, ListHostedZonesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListHostedZonesResponseFetcher();
    }

    public Iterator<ListHostedZonesResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<HostedZone> hostedZones() {
        Function<ListHostedZonesResponse, Iterator> getIterator = response -> response != null ? response.hostedZones().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class ListHostedZonesResponseFetcher
    implements NextPageFetcher<ListHostedZonesResponse> {
        private ListHostedZonesResponseFetcher() {
        }

        public boolean hasNextPage(ListHostedZonesResponse previousPage) {
            return previousPage.isTruncated();
        }

        public ListHostedZonesResponse nextPage(ListHostedZonesResponse previousPage) {
            if (previousPage == null) {
                return ListHostedZonesPaginator.this.client.listHostedZones(ListHostedZonesPaginator.this.firstRequest);
            }
            return ListHostedZonesPaginator.this.client.listHostedZones((ListHostedZonesRequest)((Object)ListHostedZonesPaginator.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

