/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.route53.model.ChangeInfo;

public class ChangeInfoUnmarshaller
implements Unmarshaller<ChangeInfo, StaxUnmarshallerContext> {
    private static final ChangeInfoUnmarshaller INSTANCE = new ChangeInfoUnmarshaller();

    public ChangeInfo unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        ChangeInfo.Builder changeInfo = ChangeInfo.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Id", targetDepth)) {
                    changeInfo.id(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Status", targetDepth)) {
                    changeInfo.status(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("SubmittedAt", targetDepth)) {
                    changeInfo.submittedAt(SimpleTypeStaxUnmarshallers.InstantUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Comment", targetDepth)) continue;
                changeInfo.comment(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (ChangeInfo)changeInfo.build();
    }

    public static ChangeInfoUnmarshaller getInstance() {
        return INSTANCE;
    }
}

