/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53domains.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetDomainSuggestionsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, GetDomainSuggestionsRequest> {
    private final String domainName;
    private final Integer suggestionCount;
    private final Boolean onlyAvailable;

    private GetDomainSuggestionsRequest(BuilderImpl builder) {
        this.domainName = builder.domainName;
        this.suggestionCount = builder.suggestionCount;
        this.onlyAvailable = builder.onlyAvailable;
    }

    public String domainName() {
        return this.domainName;
    }

    public Integer suggestionCount() {
        return this.suggestionCount;
    }

    public Boolean onlyAvailable() {
        return this.onlyAvailable;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.suggestionCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.onlyAvailable());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDomainSuggestionsRequest)) {
            return false;
        }
        GetDomainSuggestionsRequest other = (GetDomainSuggestionsRequest)((Object)obj);
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.suggestionCount(), other.suggestionCount()) && Objects.equals(this.onlyAvailable(), other.onlyAvailable());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.domainName() != null) {
            sb.append("DomainName: ").append(this.domainName()).append(",");
        }
        if (this.suggestionCount() != null) {
            sb.append("SuggestionCount: ").append(this.suggestionCount()).append(",");
        }
        if (this.onlyAvailable() != null) {
            sb.append("OnlyAvailable: ").append(this.onlyAvailable()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.of(clazz.cast(this.domainName()));
            }
            case "SuggestionCount": {
                return Optional.of(clazz.cast(this.suggestionCount()));
            }
            case "OnlyAvailable": {
                return Optional.of(clazz.cast(this.onlyAvailable()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String domainName;
        private Integer suggestionCount;
        private Boolean onlyAvailable;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDomainSuggestionsRequest model) {
            this.domainName(model.domainName);
            this.suggestionCount(model.suggestionCount);
            this.onlyAvailable(model.onlyAvailable);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final Integer getSuggestionCount() {
            return this.suggestionCount;
        }

        @Override
        public final Builder suggestionCount(Integer suggestionCount) {
            this.suggestionCount = suggestionCount;
            return this;
        }

        public final void setSuggestionCount(Integer suggestionCount) {
            this.suggestionCount = suggestionCount;
        }

        public final Boolean getOnlyAvailable() {
            return this.onlyAvailable;
        }

        @Override
        public final Builder onlyAvailable(Boolean onlyAvailable) {
            this.onlyAvailable = onlyAvailable;
            return this;
        }

        public final void setOnlyAvailable(Boolean onlyAvailable) {
            this.onlyAvailable = onlyAvailable;
        }

        public GetDomainSuggestionsRequest build() {
            return new GetDomainSuggestionsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetDomainSuggestionsRequest> {
        public Builder domainName(String var1);

        public Builder suggestionCount(Integer var1);

        public Builder onlyAvailable(Boolean var1);
    }
}

