/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that lists the name servers in a delegation set, as well as the <code>CallerReference</code> and the
 * <code>ID</code> for the delegation set.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DelegationSet implements ToCopyableBuilder<DelegationSet.Builder, DelegationSet> {
    private final String id;

    private final String callerReference;

    private final List<String> nameServers;

    private DelegationSet(BuilderImpl builder) {
        this.id = builder.id;
        this.callerReference = builder.callerReference;
        this.nameServers = builder.nameServers;
    }

    /**
     * <p>
     * The ID that Amazon Route 53 assigns to a reusable delegation set.
     * </p>
     * 
     * @return The ID that Amazon Route 53 assigns to a reusable delegation set.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * The value that you specified for <code>CallerReference</code> when you created the reusable delegation set.
     * </p>
     * 
     * @return The value that you specified for <code>CallerReference</code> when you created the reusable delegation
     *         set.
     */
    public String callerReference() {
        return callerReference;
    }

    /**
     * <p>
     * A complex type that contains a list of the authoritative name servers for a hosted zone or for a reusable
     * delegation set.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A complex type that contains a list of the authoritative name servers for a hosted zone or for a reusable
     *         delegation set.
     */
    public List<String> nameServers() {
        return nameServers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(callerReference());
        hashCode = 31 * hashCode + Objects.hashCode(nameServers());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DelegationSet)) {
            return false;
        }
        DelegationSet other = (DelegationSet) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(callerReference(), other.callerReference())
                && Objects.equals(nameServers(), other.nameServers());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (id() != null) {
            sb.append("Id: ").append(id()).append(",");
        }
        if (callerReference() != null) {
            sb.append("CallerReference: ").append(callerReference()).append(",");
        }
        if (nameServers() != null) {
            sb.append("NameServers: ").append(nameServers()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.of(clazz.cast(id()));
        case "CallerReference":
            return Optional.of(clazz.cast(callerReference()));
        case "NameServers":
            return Optional.of(clazz.cast(nameServers()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DelegationSet> {
        /**
         * <p>
         * The ID that Amazon Route 53 assigns to a reusable delegation set.
         * </p>
         * 
         * @param id
         *        The ID that Amazon Route 53 assigns to a reusable delegation set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The value that you specified for <code>CallerReference</code> when you created the reusable delegation set.
         * </p>
         * 
         * @param callerReference
         *        The value that you specified for <code>CallerReference</code> when you created the reusable delegation
         *        set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder callerReference(String callerReference);

        /**
         * <p>
         * A complex type that contains a list of the authoritative name servers for a hosted zone or for a reusable
         * delegation set.
         * </p>
         * 
         * @param nameServers
         *        A complex type that contains a list of the authoritative name servers for a hosted zone or for a
         *        reusable delegation set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nameServers(Collection<String> nameServers);

        /**
         * <p>
         * A complex type that contains a list of the authoritative name servers for a hosted zone or for a reusable
         * delegation set.
         * </p>
         * 
         * @param nameServers
         *        A complex type that contains a list of the authoritative name servers for a hosted zone or for a
         *        reusable delegation set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nameServers(String... nameServers);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String callerReference;

        private List<String> nameServers;

        private BuilderImpl() {
        }

        private BuilderImpl(DelegationSet model) {
            id(model.id);
            callerReference(model.callerReference);
            nameServers(model.nameServers);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getCallerReference() {
            return callerReference;
        }

        @Override
        public final Builder callerReference(String callerReference) {
            this.callerReference = callerReference;
            return this;
        }

        public final void setCallerReference(String callerReference) {
            this.callerReference = callerReference;
        }

        public final Collection<String> getNameServers() {
            return nameServers;
        }

        @Override
        public final Builder nameServers(Collection<String> nameServers) {
            this.nameServers = DelegationSetNameServersCopier.copy(nameServers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nameServers(String... nameServers) {
            nameServers(Arrays.asList(nameServers));
            return this;
        }

        public final void setNameServers(Collection<String> nameServers) {
            this.nameServers = DelegationSetNameServersCopier.copy(nameServers);
        }

        @Override
        public DelegationSet build() {
            return new DelegationSet(this);
        }
    }
}
