/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A request to delete a reusable delegation set.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DeleteReusableDelegationSetRequest extends Route53Request implements
        ToCopyableBuilder<DeleteReusableDelegationSetRequest.Builder, DeleteReusableDelegationSetRequest> {
    private final String id;

    private DeleteReusableDelegationSetRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
    }

    /**
     * <p>
     * The ID of the reusable delegation set that you want to delete.
     * </p>
     * 
     * @return The ID of the reusable delegation set that you want to delete.
     */
    public String id() {
        return id;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteReusableDelegationSetRequest)) {
            return false;
        }
        DeleteReusableDelegationSetRequest other = (DeleteReusableDelegationSetRequest) obj;
        return Objects.equals(id(), other.id());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (id() != null) {
            sb.append("Id: ").append(id()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.of(clazz.cast(id()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends Route53Request.Builder, CopyableBuilder<Builder, DeleteReusableDelegationSetRequest> {
        /**
         * <p>
         * The ID of the reusable delegation set that you want to delete.
         * </p>
         * 
         * @param id
         *        The ID of the reusable delegation set that you want to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends Route53Request.BuilderImpl implements Builder {
        private String id;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteReusableDelegationSetRequest model) {
            id(model.id);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DeleteReusableDelegationSetRequest build() {
            return new DeleteReusableDelegationSetRequest(this);
        }
    }
}
