/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains the codes and full continent, country, and subdivision names for the specified
 * <code>geolocation</code> code.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class GeoLocationDetails implements ToCopyableBuilder<GeoLocationDetails.Builder, GeoLocationDetails> {
    private final String continentCode;

    private final String continentName;

    private final String countryCode;

    private final String countryName;

    private final String subdivisionCode;

    private final String subdivisionName;

    private GeoLocationDetails(BuilderImpl builder) {
        this.continentCode = builder.continentCode;
        this.continentName = builder.continentName;
        this.countryCode = builder.countryCode;
        this.countryName = builder.countryName;
        this.subdivisionCode = builder.subdivisionCode;
        this.subdivisionName = builder.subdivisionName;
    }

    /**
     * <p>
     * The two-letter code for the continent.
     * </p>
     * 
     * @return The two-letter code for the continent.
     */
    public String continentCode() {
        return continentCode;
    }

    /**
     * <p>
     * The full name of the continent.
     * </p>
     * 
     * @return The full name of the continent.
     */
    public String continentName() {
        return continentName;
    }

    /**
     * <p>
     * The two-letter code for the country.
     * </p>
     * 
     * @return The two-letter code for the country.
     */
    public String countryCode() {
        return countryCode;
    }

    /**
     * <p>
     * The name of the country.
     * </p>
     * 
     * @return The name of the country.
     */
    public String countryName() {
        return countryName;
    }

    /**
     * <p>
     * The code for the subdivision, for example, a state in the United States or a province in Canada.
     * </p>
     * 
     * @return The code for the subdivision, for example, a state in the United States or a province in Canada.
     */
    public String subdivisionCode() {
        return subdivisionCode;
    }

    /**
     * <p>
     * The full name of the subdivision, for example, a state in the United States or a province in Canada.
     * </p>
     * 
     * @return The full name of the subdivision, for example, a state in the United States or a province in Canada.
     */
    public String subdivisionName() {
        return subdivisionName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(continentCode());
        hashCode = 31 * hashCode + Objects.hashCode(continentName());
        hashCode = 31 * hashCode + Objects.hashCode(countryCode());
        hashCode = 31 * hashCode + Objects.hashCode(countryName());
        hashCode = 31 * hashCode + Objects.hashCode(subdivisionCode());
        hashCode = 31 * hashCode + Objects.hashCode(subdivisionName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GeoLocationDetails)) {
            return false;
        }
        GeoLocationDetails other = (GeoLocationDetails) obj;
        return Objects.equals(continentCode(), other.continentCode()) && Objects.equals(continentName(), other.continentName())
                && Objects.equals(countryCode(), other.countryCode()) && Objects.equals(countryName(), other.countryName())
                && Objects.equals(subdivisionCode(), other.subdivisionCode())
                && Objects.equals(subdivisionName(), other.subdivisionName());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (continentCode() != null) {
            sb.append("ContinentCode: ").append(continentCode()).append(",");
        }
        if (continentName() != null) {
            sb.append("ContinentName: ").append(continentName()).append(",");
        }
        if (countryCode() != null) {
            sb.append("CountryCode: ").append(countryCode()).append(",");
        }
        if (countryName() != null) {
            sb.append("CountryName: ").append(countryName()).append(",");
        }
        if (subdivisionCode() != null) {
            sb.append("SubdivisionCode: ").append(subdivisionCode()).append(",");
        }
        if (subdivisionName() != null) {
            sb.append("SubdivisionName: ").append(subdivisionName()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ContinentCode":
            return Optional.of(clazz.cast(continentCode()));
        case "ContinentName":
            return Optional.of(clazz.cast(continentName()));
        case "CountryCode":
            return Optional.of(clazz.cast(countryCode()));
        case "CountryName":
            return Optional.of(clazz.cast(countryName()));
        case "SubdivisionCode":
            return Optional.of(clazz.cast(subdivisionCode()));
        case "SubdivisionName":
            return Optional.of(clazz.cast(subdivisionName()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, GeoLocationDetails> {
        /**
         * <p>
         * The two-letter code for the continent.
         * </p>
         * 
         * @param continentCode
         *        The two-letter code for the continent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder continentCode(String continentCode);

        /**
         * <p>
         * The full name of the continent.
         * </p>
         * 
         * @param continentName
         *        The full name of the continent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder continentName(String continentName);

        /**
         * <p>
         * The two-letter code for the country.
         * </p>
         * 
         * @param countryCode
         *        The two-letter code for the country.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder countryCode(String countryCode);

        /**
         * <p>
         * The name of the country.
         * </p>
         * 
         * @param countryName
         *        The name of the country.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder countryName(String countryName);

        /**
         * <p>
         * The code for the subdivision, for example, a state in the United States or a province in Canada.
         * </p>
         * 
         * @param subdivisionCode
         *        The code for the subdivision, for example, a state in the United States or a province in Canada.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subdivisionCode(String subdivisionCode);

        /**
         * <p>
         * The full name of the subdivision, for example, a state in the United States or a province in Canada.
         * </p>
         * 
         * @param subdivisionName
         *        The full name of the subdivision, for example, a state in the United States or a province in Canada.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subdivisionName(String subdivisionName);
    }

    static final class BuilderImpl implements Builder {
        private String continentCode;

        private String continentName;

        private String countryCode;

        private String countryName;

        private String subdivisionCode;

        private String subdivisionName;

        private BuilderImpl() {
        }

        private BuilderImpl(GeoLocationDetails model) {
            continentCode(model.continentCode);
            continentName(model.continentName);
            countryCode(model.countryCode);
            countryName(model.countryName);
            subdivisionCode(model.subdivisionCode);
            subdivisionName(model.subdivisionName);
        }

        public final String getContinentCode() {
            return continentCode;
        }

        @Override
        public final Builder continentCode(String continentCode) {
            this.continentCode = continentCode;
            return this;
        }

        public final void setContinentCode(String continentCode) {
            this.continentCode = continentCode;
        }

        public final String getContinentName() {
            return continentName;
        }

        @Override
        public final Builder continentName(String continentName) {
            this.continentName = continentName;
            return this;
        }

        public final void setContinentName(String continentName) {
            this.continentName = continentName;
        }

        public final String getCountryCode() {
            return countryCode;
        }

        @Override
        public final Builder countryCode(String countryCode) {
            this.countryCode = countryCode;
            return this;
        }

        public final void setCountryCode(String countryCode) {
            this.countryCode = countryCode;
        }

        public final String getCountryName() {
            return countryName;
        }

        @Override
        public final Builder countryName(String countryName) {
            this.countryName = countryName;
            return this;
        }

        public final void setCountryName(String countryName) {
            this.countryName = countryName;
        }

        public final String getSubdivisionCode() {
            return subdivisionCode;
        }

        @Override
        public final Builder subdivisionCode(String subdivisionCode) {
            this.subdivisionCode = subdivisionCode;
            return this;
        }

        public final void setSubdivisionCode(String subdivisionCode) {
            this.subdivisionCode = subdivisionCode;
        }

        public final String getSubdivisionName() {
            return subdivisionName;
        }

        @Override
        public final Builder subdivisionName(String subdivisionName) {
            this.subdivisionName = subdivisionName;
            return this;
        }

        public final void setSubdivisionName(String subdivisionName) {
            this.subdivisionName = subdivisionName;
        }

        @Override
        public GeoLocationDetails build() {
            return new GeoLocationDetails(this);
        }
    }
}
