/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains the response to a <code>GetHealthCheckCount</code> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class GetHealthCheckCountResponse extends Route53Response implements
        ToCopyableBuilder<GetHealthCheckCountResponse.Builder, GetHealthCheckCountResponse> {
    private final Long healthCheckCount;

    private GetHealthCheckCountResponse(BuilderImpl builder) {
        super(builder);
        this.healthCheckCount = builder.healthCheckCount;
    }

    /**
     * <p>
     * The number of health checks associated with the current AWS account.
     * </p>
     * 
     * @return The number of health checks associated with the current AWS account.
     */
    public Long healthCheckCount() {
        return healthCheckCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(healthCheckCount());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetHealthCheckCountResponse)) {
            return false;
        }
        GetHealthCheckCountResponse other = (GetHealthCheckCountResponse) obj;
        return Objects.equals(healthCheckCount(), other.healthCheckCount());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (healthCheckCount() != null) {
            sb.append("HealthCheckCount: ").append(healthCheckCount()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HealthCheckCount":
            return Optional.of(clazz.cast(healthCheckCount()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends Route53Response.Builder, CopyableBuilder<Builder, GetHealthCheckCountResponse> {
        /**
         * <p>
         * The number of health checks associated with the current AWS account.
         * </p>
         * 
         * @param healthCheckCount
         *        The number of health checks associated with the current AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthCheckCount(Long healthCheckCount);
    }

    static final class BuilderImpl extends Route53Response.BuilderImpl implements Builder {
        private Long healthCheckCount;

        private BuilderImpl() {
        }

        private BuilderImpl(GetHealthCheckCountResponse model) {
            healthCheckCount(model.healthCheckCount);
        }

        public final Long getHealthCheckCount() {
            return healthCheckCount;
        }

        @Override
        public final Builder healthCheckCount(Long healthCheckCount) {
            this.healthCheckCount = healthCheckCount;
            return this;
        }

        public final void setHealthCheckCount(Long healthCheckCount) {
            this.healthCheckCount = healthCheckCount;
        }

        @Override
        public GetHealthCheckCountResponse build() {
            return new GetHealthCheckCountResponse(this);
        }
    }
}
