/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains the requested limit.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class GetReusableDelegationSetLimitResponse extends Route53Response implements
        ToCopyableBuilder<GetReusableDelegationSetLimitResponse.Builder, GetReusableDelegationSetLimitResponse> {
    private final ReusableDelegationSetLimit limit;

    private final Long count;

    private GetReusableDelegationSetLimitResponse(BuilderImpl builder) {
        super(builder);
        this.limit = builder.limit;
        this.count = builder.count;
    }

    /**
     * <p>
     * The current setting for the limit on hosted zones that you can associate with the specified reusable delegation
     * set.
     * </p>
     * 
     * @return The current setting for the limit on hosted zones that you can associate with the specified reusable
     *         delegation set.
     */
    public ReusableDelegationSetLimit limit() {
        return limit;
    }

    /**
     * <p>
     * The current number of hosted zones that you can associate with the specified reusable delegation set.
     * </p>
     * 
     * @return The current number of hosted zones that you can associate with the specified reusable delegation set.
     */
    public Long count() {
        return count;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(limit());
        hashCode = 31 * hashCode + Objects.hashCode(count());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetReusableDelegationSetLimitResponse)) {
            return false;
        }
        GetReusableDelegationSetLimitResponse other = (GetReusableDelegationSetLimitResponse) obj;
        return Objects.equals(limit(), other.limit()) && Objects.equals(count(), other.count());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (limit() != null) {
            sb.append("Limit: ").append(limit()).append(",");
        }
        if (count() != null) {
            sb.append("Count: ").append(count()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Limit":
            return Optional.of(clazz.cast(limit()));
        case "Count":
            return Optional.of(clazz.cast(count()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends Route53Response.Builder, CopyableBuilder<Builder, GetReusableDelegationSetLimitResponse> {
        /**
         * <p>
         * The current setting for the limit on hosted zones that you can associate with the specified reusable
         * delegation set.
         * </p>
         * 
         * @param limit
         *        The current setting for the limit on hosted zones that you can associate with the specified reusable
         *        delegation set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(ReusableDelegationSetLimit limit);

        /**
         * <p>
         * The current setting for the limit on hosted zones that you can associate with the specified reusable
         * delegation set.
         * </p>
         * This is a convenience that creates an instance of the {@link ReusableDelegationSetLimit.Builder} avoiding the
         * need to create one manually via {@link ReusableDelegationSetLimit#builder()}.
         *
         * When the {@link Consumer} completes, {@link ReusableDelegationSetLimit.Builder#build()} is called immediately
         * and its result is passed to {@link #limit(ReusableDelegationSetLimit)}.
         * 
         * @param limit
         *        a consumer that will call methods on {@link ReusableDelegationSetLimit.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #limit(ReusableDelegationSetLimit)
         */
        default Builder limit(Consumer<ReusableDelegationSetLimit.Builder> limit) {
            return limit(ReusableDelegationSetLimit.builder().apply(limit).build());
        }

        /**
         * <p>
         * The current number of hosted zones that you can associate with the specified reusable delegation set.
         * </p>
         * 
         * @param count
         *        The current number of hosted zones that you can associate with the specified reusable delegation set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder count(Long count);
    }

    static final class BuilderImpl extends Route53Response.BuilderImpl implements Builder {
        private ReusableDelegationSetLimit limit;

        private Long count;

        private BuilderImpl() {
        }

        private BuilderImpl(GetReusableDelegationSetLimitResponse model) {
            limit(model.limit);
            count(model.count);
        }

        public final ReusableDelegationSetLimit.Builder getLimit() {
            return limit != null ? limit.toBuilder() : null;
        }

        @Override
        public final Builder limit(ReusableDelegationSetLimit limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(ReusableDelegationSetLimit.BuilderImpl limit) {
            this.limit = limit != null ? limit.build() : null;
        }

        public final Long getCount() {
            return count;
        }

        @Override
        public final Builder count(Long count) {
            this.count = count;
            return this;
        }

        public final void setCount(Long count) {
            this.count = count;
        }

        @Override
        public GetReusableDelegationSetLimitResponse build() {
            return new GetReusableDelegationSetLimitResponse(this);
        }
    }
}
