/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains the response information for the request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class GetTrafficPolicyResponse extends Route53Response implements
        ToCopyableBuilder<GetTrafficPolicyResponse.Builder, GetTrafficPolicyResponse> {
    private final TrafficPolicy trafficPolicy;

    private GetTrafficPolicyResponse(BuilderImpl builder) {
        super(builder);
        this.trafficPolicy = builder.trafficPolicy;
    }

    /**
     * <p>
     * A complex type that contains settings for the specified traffic policy.
     * </p>
     * 
     * @return A complex type that contains settings for the specified traffic policy.
     */
    public TrafficPolicy trafficPolicy() {
        return trafficPolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(trafficPolicy());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTrafficPolicyResponse)) {
            return false;
        }
        GetTrafficPolicyResponse other = (GetTrafficPolicyResponse) obj;
        return Objects.equals(trafficPolicy(), other.trafficPolicy());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (trafficPolicy() != null) {
            sb.append("TrafficPolicy: ").append(trafficPolicy()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TrafficPolicy":
            return Optional.of(clazz.cast(trafficPolicy()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends Route53Response.Builder, CopyableBuilder<Builder, GetTrafficPolicyResponse> {
        /**
         * <p>
         * A complex type that contains settings for the specified traffic policy.
         * </p>
         * 
         * @param trafficPolicy
         *        A complex type that contains settings for the specified traffic policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trafficPolicy(TrafficPolicy trafficPolicy);

        /**
         * <p>
         * A complex type that contains settings for the specified traffic policy.
         * </p>
         * This is a convenience that creates an instance of the {@link TrafficPolicy.Builder} avoiding the need to
         * create one manually via {@link TrafficPolicy#builder()}.
         *
         * When the {@link Consumer} completes, {@link TrafficPolicy.Builder#build()} is called immediately and its
         * result is passed to {@link #trafficPolicy(TrafficPolicy)}.
         * 
         * @param trafficPolicy
         *        a consumer that will call methods on {@link TrafficPolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trafficPolicy(TrafficPolicy)
         */
        default Builder trafficPolicy(Consumer<TrafficPolicy.Builder> trafficPolicy) {
            return trafficPolicy(TrafficPolicy.builder().apply(trafficPolicy).build());
        }
    }

    static final class BuilderImpl extends Route53Response.BuilderImpl implements Builder {
        private TrafficPolicy trafficPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTrafficPolicyResponse model) {
            trafficPolicy(model.trafficPolicy);
        }

        public final TrafficPolicy.Builder getTrafficPolicy() {
            return trafficPolicy != null ? trafficPolicy.toBuilder() : null;
        }

        @Override
        public final Builder trafficPolicy(TrafficPolicy trafficPolicy) {
            this.trafficPolicy = trafficPolicy;
            return this;
        }

        public final void setTrafficPolicy(TrafficPolicy.BuilderImpl trafficPolicy) {
            this.trafficPolicy = trafficPolicy != null ? trafficPolicy.build() : null;
        }

        @Override
        public GetTrafficPolicyResponse build() {
            return new GetTrafficPolicyResponse(this);
        }
    }
}
