/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains information about one health check that is associated with the current AWS account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class HealthCheck implements ToCopyableBuilder<HealthCheck.Builder, HealthCheck> {
    private final String id;

    private final String callerReference;

    private final LinkedService linkedService;

    private final HealthCheckConfig healthCheckConfig;

    private final Long healthCheckVersion;

    private final CloudWatchAlarmConfiguration cloudWatchAlarmConfiguration;

    private HealthCheck(BuilderImpl builder) {
        this.id = builder.id;
        this.callerReference = builder.callerReference;
        this.linkedService = builder.linkedService;
        this.healthCheckConfig = builder.healthCheckConfig;
        this.healthCheckVersion = builder.healthCheckVersion;
        this.cloudWatchAlarmConfiguration = builder.cloudWatchAlarmConfiguration;
    }

    /**
     * <p>
     * The identifier that Amazon Route 53assigned to the health check when you created it. When you add or update a
     * resource record set, you use this value to specify which health check to use. The value can be up to 64
     * characters long.
     * </p>
     * 
     * @return The identifier that Amazon Route 53assigned to the health check when you created it. When you add or
     *         update a resource record set, you use this value to specify which health check to use. The value can be
     *         up to 64 characters long.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * A unique string that you specified when you created the health check.
     * </p>
     * 
     * @return A unique string that you specified when you created the health check.
     */
    public String callerReference() {
        return callerReference;
    }

    /**
     * <p>
     * If the health check was created by another service, the service that created the health check. When a health
     * check is created by another service, you can't edit or delete it using Amazon Route 53.
     * </p>
     * 
     * @return If the health check was created by another service, the service that created the health check. When a
     *         health check is created by another service, you can't edit or delete it using Amazon Route 53.
     */
    public LinkedService linkedService() {
        return linkedService;
    }

    /**
     * <p>
     * A complex type that contains detailed information about one health check.
     * </p>
     * 
     * @return A complex type that contains detailed information about one health check.
     */
    public HealthCheckConfig healthCheckConfig() {
        return healthCheckConfig;
    }

    /**
     * <p>
     * The version of the health check. You can optionally pass this value in a call to <code>UpdateHealthCheck</code>
     * to prevent overwriting another change to the health check.
     * </p>
     * 
     * @return The version of the health check. You can optionally pass this value in a call to
     *         <code>UpdateHealthCheck</code> to prevent overwriting another change to the health check.
     */
    public Long healthCheckVersion() {
        return healthCheckVersion;
    }

    /**
     * <p>
     * A complex type that contains information about the CloudWatch alarm that Amazon Route 53 is monitoring for this
     * health check.
     * </p>
     * 
     * @return A complex type that contains information about the CloudWatch alarm that Amazon Route 53 is monitoring
     *         for this health check.
     */
    public CloudWatchAlarmConfiguration cloudWatchAlarmConfiguration() {
        return cloudWatchAlarmConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(callerReference());
        hashCode = 31 * hashCode + Objects.hashCode(linkedService());
        hashCode = 31 * hashCode + Objects.hashCode(healthCheckConfig());
        hashCode = 31 * hashCode + Objects.hashCode(healthCheckVersion());
        hashCode = 31 * hashCode + Objects.hashCode(cloudWatchAlarmConfiguration());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HealthCheck)) {
            return false;
        }
        HealthCheck other = (HealthCheck) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(callerReference(), other.callerReference())
                && Objects.equals(linkedService(), other.linkedService())
                && Objects.equals(healthCheckConfig(), other.healthCheckConfig())
                && Objects.equals(healthCheckVersion(), other.healthCheckVersion())
                && Objects.equals(cloudWatchAlarmConfiguration(), other.cloudWatchAlarmConfiguration());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (id() != null) {
            sb.append("Id: ").append(id()).append(",");
        }
        if (callerReference() != null) {
            sb.append("CallerReference: ").append(callerReference()).append(",");
        }
        if (linkedService() != null) {
            sb.append("LinkedService: ").append(linkedService()).append(",");
        }
        if (healthCheckConfig() != null) {
            sb.append("HealthCheckConfig: ").append(healthCheckConfig()).append(",");
        }
        if (healthCheckVersion() != null) {
            sb.append("HealthCheckVersion: ").append(healthCheckVersion()).append(",");
        }
        if (cloudWatchAlarmConfiguration() != null) {
            sb.append("CloudWatchAlarmConfiguration: ").append(cloudWatchAlarmConfiguration()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.of(clazz.cast(id()));
        case "CallerReference":
            return Optional.of(clazz.cast(callerReference()));
        case "LinkedService":
            return Optional.of(clazz.cast(linkedService()));
        case "HealthCheckConfig":
            return Optional.of(clazz.cast(healthCheckConfig()));
        case "HealthCheckVersion":
            return Optional.of(clazz.cast(healthCheckVersion()));
        case "CloudWatchAlarmConfiguration":
            return Optional.of(clazz.cast(cloudWatchAlarmConfiguration()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, HealthCheck> {
        /**
         * <p>
         * The identifier that Amazon Route 53assigned to the health check when you created it. When you add or update a
         * resource record set, you use this value to specify which health check to use. The value can be up to 64
         * characters long.
         * </p>
         * 
         * @param id
         *        The identifier that Amazon Route 53assigned to the health check when you created it. When you add or
         *        update a resource record set, you use this value to specify which health check to use. The value can
         *        be up to 64 characters long.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * A unique string that you specified when you created the health check.
         * </p>
         * 
         * @param callerReference
         *        A unique string that you specified when you created the health check.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder callerReference(String callerReference);

        /**
         * <p>
         * If the health check was created by another service, the service that created the health check. When a health
         * check is created by another service, you can't edit or delete it using Amazon Route 53.
         * </p>
         * 
         * @param linkedService
         *        If the health check was created by another service, the service that created the health check. When a
         *        health check is created by another service, you can't edit or delete it using Amazon Route 53.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder linkedService(LinkedService linkedService);

        /**
         * <p>
         * If the health check was created by another service, the service that created the health check. When a health
         * check is created by another service, you can't edit or delete it using Amazon Route 53.
         * </p>
         * This is a convenience that creates an instance of the {@link LinkedService.Builder} avoiding the need to
         * create one manually via {@link LinkedService#builder()}.
         *
         * When the {@link Consumer} completes, {@link LinkedService.Builder#build()} is called immediately and its
         * result is passed to {@link #linkedService(LinkedService)}.
         * 
         * @param linkedService
         *        a consumer that will call methods on {@link LinkedService.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #linkedService(LinkedService)
         */
        default Builder linkedService(Consumer<LinkedService.Builder> linkedService) {
            return linkedService(LinkedService.builder().apply(linkedService).build());
        }

        /**
         * <p>
         * A complex type that contains detailed information about one health check.
         * </p>
         * 
         * @param healthCheckConfig
         *        A complex type that contains detailed information about one health check.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthCheckConfig(HealthCheckConfig healthCheckConfig);

        /**
         * <p>
         * A complex type that contains detailed information about one health check.
         * </p>
         * This is a convenience that creates an instance of the {@link HealthCheckConfig.Builder} avoiding the need to
         * create one manually via {@link HealthCheckConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link HealthCheckConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #healthCheckConfig(HealthCheckConfig)}.
         * 
         * @param healthCheckConfig
         *        a consumer that will call methods on {@link HealthCheckConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #healthCheckConfig(HealthCheckConfig)
         */
        default Builder healthCheckConfig(Consumer<HealthCheckConfig.Builder> healthCheckConfig) {
            return healthCheckConfig(HealthCheckConfig.builder().apply(healthCheckConfig).build());
        }

        /**
         * <p>
         * The version of the health check. You can optionally pass this value in a call to
         * <code>UpdateHealthCheck</code> to prevent overwriting another change to the health check.
         * </p>
         * 
         * @param healthCheckVersion
         *        The version of the health check. You can optionally pass this value in a call to
         *        <code>UpdateHealthCheck</code> to prevent overwriting another change to the health check.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthCheckVersion(Long healthCheckVersion);

        /**
         * <p>
         * A complex type that contains information about the CloudWatch alarm that Amazon Route 53 is monitoring for
         * this health check.
         * </p>
         * 
         * @param cloudWatchAlarmConfiguration
         *        A complex type that contains information about the CloudWatch alarm that Amazon Route 53 is monitoring
         *        for this health check.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchAlarmConfiguration(CloudWatchAlarmConfiguration cloudWatchAlarmConfiguration);

        /**
         * <p>
         * A complex type that contains information about the CloudWatch alarm that Amazon Route 53 is monitoring for
         * this health check.
         * </p>
         * This is a convenience that creates an instance of the {@link CloudWatchAlarmConfiguration.Builder} avoiding
         * the need to create one manually via {@link CloudWatchAlarmConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link CloudWatchAlarmConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #cloudWatchAlarmConfiguration(CloudWatchAlarmConfiguration)}.
         * 
         * @param cloudWatchAlarmConfiguration
         *        a consumer that will call methods on {@link CloudWatchAlarmConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cloudWatchAlarmConfiguration(CloudWatchAlarmConfiguration)
         */
        default Builder cloudWatchAlarmConfiguration(Consumer<CloudWatchAlarmConfiguration.Builder> cloudWatchAlarmConfiguration) {
            return cloudWatchAlarmConfiguration(CloudWatchAlarmConfiguration.builder().apply(cloudWatchAlarmConfiguration)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String callerReference;

        private LinkedService linkedService;

        private HealthCheckConfig healthCheckConfig;

        private Long healthCheckVersion;

        private CloudWatchAlarmConfiguration cloudWatchAlarmConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(HealthCheck model) {
            id(model.id);
            callerReference(model.callerReference);
            linkedService(model.linkedService);
            healthCheckConfig(model.healthCheckConfig);
            healthCheckVersion(model.healthCheckVersion);
            cloudWatchAlarmConfiguration(model.cloudWatchAlarmConfiguration);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getCallerReference() {
            return callerReference;
        }

        @Override
        public final Builder callerReference(String callerReference) {
            this.callerReference = callerReference;
            return this;
        }

        public final void setCallerReference(String callerReference) {
            this.callerReference = callerReference;
        }

        public final LinkedService.Builder getLinkedService() {
            return linkedService != null ? linkedService.toBuilder() : null;
        }

        @Override
        public final Builder linkedService(LinkedService linkedService) {
            this.linkedService = linkedService;
            return this;
        }

        public final void setLinkedService(LinkedService.BuilderImpl linkedService) {
            this.linkedService = linkedService != null ? linkedService.build() : null;
        }

        public final HealthCheckConfig.Builder getHealthCheckConfig() {
            return healthCheckConfig != null ? healthCheckConfig.toBuilder() : null;
        }

        @Override
        public final Builder healthCheckConfig(HealthCheckConfig healthCheckConfig) {
            this.healthCheckConfig = healthCheckConfig;
            return this;
        }

        public final void setHealthCheckConfig(HealthCheckConfig.BuilderImpl healthCheckConfig) {
            this.healthCheckConfig = healthCheckConfig != null ? healthCheckConfig.build() : null;
        }

        public final Long getHealthCheckVersion() {
            return healthCheckVersion;
        }

        @Override
        public final Builder healthCheckVersion(Long healthCheckVersion) {
            this.healthCheckVersion = healthCheckVersion;
            return this;
        }

        public final void setHealthCheckVersion(Long healthCheckVersion) {
            this.healthCheckVersion = healthCheckVersion;
        }

        public final CloudWatchAlarmConfiguration.Builder getCloudWatchAlarmConfiguration() {
            return cloudWatchAlarmConfiguration != null ? cloudWatchAlarmConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder cloudWatchAlarmConfiguration(CloudWatchAlarmConfiguration cloudWatchAlarmConfiguration) {
            this.cloudWatchAlarmConfiguration = cloudWatchAlarmConfiguration;
            return this;
        }

        public final void setCloudWatchAlarmConfiguration(CloudWatchAlarmConfiguration.BuilderImpl cloudWatchAlarmConfiguration) {
            this.cloudWatchAlarmConfiguration = cloudWatchAlarmConfiguration != null ? cloudWatchAlarmConfiguration.build()
                    : null;
        }

        @Override
        public HealthCheck build() {
            return new HealthCheck(this);
        }
    }
}
