/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type containing the response information for the request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListGeoLocationsResponse extends Route53Response implements
        ToCopyableBuilder<ListGeoLocationsResponse.Builder, ListGeoLocationsResponse> {
    private final List<GeoLocationDetails> geoLocationDetailsList;

    private final Boolean isTruncated;

    private final String nextContinentCode;

    private final String nextCountryCode;

    private final String nextSubdivisionCode;

    private final String maxItems;

    private ListGeoLocationsResponse(BuilderImpl builder) {
        super(builder);
        this.geoLocationDetailsList = builder.geoLocationDetailsList;
        this.isTruncated = builder.isTruncated;
        this.nextContinentCode = builder.nextContinentCode;
        this.nextCountryCode = builder.nextCountryCode;
        this.nextSubdivisionCode = builder.nextSubdivisionCode;
        this.maxItems = builder.maxItems;
    }

    /**
     * <p>
     * A complex type that contains one <code>GeoLocationDetails</code> element for each location that Amazon Route 53
     * supports for geolocation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A complex type that contains one <code>GeoLocationDetails</code> element for each location that Amazon
     *         Route 53 supports for geolocation.
     */
    public List<GeoLocationDetails> geoLocationDetailsList() {
        return geoLocationDetailsList;
    }

    /**
     * <p>
     * A value that indicates whether more locations remain to be listed after the last location in this response. If
     * so, the value of <code>IsTruncated</code> is <code>true</code>. To get more values, submit another request and
     * include the values of <code>NextContinentCode</code>, <code>NextCountryCode</code>, and
     * <code>NextSubdivisionCode</code> in the <code>StartContinentCode</code>, <code>StartCountryCode</code>, and
     * <code>StartSubdivisionCode</code>, as applicable.
     * </p>
     * 
     * @return A value that indicates whether more locations remain to be listed after the last location in this
     *         response. If so, the value of <code>IsTruncated</code> is <code>true</code>. To get more values, submit
     *         another request and include the values of <code>NextContinentCode</code>, <code>NextCountryCode</code>,
     *         and <code>NextSubdivisionCode</code> in the <code>StartContinentCode</code>,
     *         <code>StartCountryCode</code>, and <code>StartSubdivisionCode</code>, as applicable.
     */
    public Boolean isTruncated() {
        return isTruncated;
    }

    /**
     * <p>
     * If <code>IsTruncated</code> is <code>true</code>, you can make a follow-up request to display more locations.
     * Enter the value of <code>NextContinentCode</code> in the <code>StartContinentCode</code> parameter in another
     * <code>ListGeoLocations</code> request.
     * </p>
     * 
     * @return If <code>IsTruncated</code> is <code>true</code>, you can make a follow-up request to display more
     *         locations. Enter the value of <code>NextContinentCode</code> in the <code>StartContinentCode</code>
     *         parameter in another <code>ListGeoLocations</code> request.
     */
    public String nextContinentCode() {
        return nextContinentCode;
    }

    /**
     * <p>
     * If <code>IsTruncated</code> is <code>true</code>, you can make a follow-up request to display more locations.
     * Enter the value of <code>NextCountryCode</code> in the <code>StartCountryCode</code> parameter in another
     * <code>ListGeoLocations</code> request.
     * </p>
     * 
     * @return If <code>IsTruncated</code> is <code>true</code>, you can make a follow-up request to display more
     *         locations. Enter the value of <code>NextCountryCode</code> in the <code>StartCountryCode</code> parameter
     *         in another <code>ListGeoLocations</code> request.
     */
    public String nextCountryCode() {
        return nextCountryCode;
    }

    /**
     * <p>
     * If <code>IsTruncated</code> is <code>true</code>, you can make a follow-up request to display more locations.
     * Enter the value of <code>NextSubdivisionCode</code> in the <code>StartSubdivisionCode</code> parameter in another
     * <code>ListGeoLocations</code> request.
     * </p>
     * 
     * @return If <code>IsTruncated</code> is <code>true</code>, you can make a follow-up request to display more
     *         locations. Enter the value of <code>NextSubdivisionCode</code> in the <code>StartSubdivisionCode</code>
     *         parameter in another <code>ListGeoLocations</code> request.
     */
    public String nextSubdivisionCode() {
        return nextSubdivisionCode;
    }

    /**
     * <p>
     * The value that you specified for <code>MaxItems</code> in the request.
     * </p>
     * 
     * @return The value that you specified for <code>MaxItems</code> in the request.
     */
    public String maxItems() {
        return maxItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(geoLocationDetailsList());
        hashCode = 31 * hashCode + Objects.hashCode(isTruncated());
        hashCode = 31 * hashCode + Objects.hashCode(nextContinentCode());
        hashCode = 31 * hashCode + Objects.hashCode(nextCountryCode());
        hashCode = 31 * hashCode + Objects.hashCode(nextSubdivisionCode());
        hashCode = 31 * hashCode + Objects.hashCode(maxItems());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListGeoLocationsResponse)) {
            return false;
        }
        ListGeoLocationsResponse other = (ListGeoLocationsResponse) obj;
        return Objects.equals(geoLocationDetailsList(), other.geoLocationDetailsList())
                && Objects.equals(isTruncated(), other.isTruncated())
                && Objects.equals(nextContinentCode(), other.nextContinentCode())
                && Objects.equals(nextCountryCode(), other.nextCountryCode())
                && Objects.equals(nextSubdivisionCode(), other.nextSubdivisionCode())
                && Objects.equals(maxItems(), other.maxItems());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (geoLocationDetailsList() != null) {
            sb.append("GeoLocationDetailsList: ").append(geoLocationDetailsList()).append(",");
        }
        if (isTruncated() != null) {
            sb.append("IsTruncated: ").append(isTruncated()).append(",");
        }
        if (nextContinentCode() != null) {
            sb.append("NextContinentCode: ").append(nextContinentCode()).append(",");
        }
        if (nextCountryCode() != null) {
            sb.append("NextCountryCode: ").append(nextCountryCode()).append(",");
        }
        if (nextSubdivisionCode() != null) {
            sb.append("NextSubdivisionCode: ").append(nextSubdivisionCode()).append(",");
        }
        if (maxItems() != null) {
            sb.append("MaxItems: ").append(maxItems()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GeoLocationDetailsList":
            return Optional.of(clazz.cast(geoLocationDetailsList()));
        case "IsTruncated":
            return Optional.of(clazz.cast(isTruncated()));
        case "NextContinentCode":
            return Optional.of(clazz.cast(nextContinentCode()));
        case "NextCountryCode":
            return Optional.of(clazz.cast(nextCountryCode()));
        case "NextSubdivisionCode":
            return Optional.of(clazz.cast(nextSubdivisionCode()));
        case "MaxItems":
            return Optional.of(clazz.cast(maxItems()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends Route53Response.Builder, CopyableBuilder<Builder, ListGeoLocationsResponse> {
        /**
         * <p>
         * A complex type that contains one <code>GeoLocationDetails</code> element for each location that Amazon Route
         * 53 supports for geolocation.
         * </p>
         * 
         * @param geoLocationDetailsList
         *        A complex type that contains one <code>GeoLocationDetails</code> element for each location that Amazon
         *        Route 53 supports for geolocation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder geoLocationDetailsList(Collection<GeoLocationDetails> geoLocationDetailsList);

        /**
         * <p>
         * A complex type that contains one <code>GeoLocationDetails</code> element for each location that Amazon Route
         * 53 supports for geolocation.
         * </p>
         * 
         * @param geoLocationDetailsList
         *        A complex type that contains one <code>GeoLocationDetails</code> element for each location that Amazon
         *        Route 53 supports for geolocation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder geoLocationDetailsList(GeoLocationDetails... geoLocationDetailsList);

        /**
         * <p>
         * A value that indicates whether more locations remain to be listed after the last location in this response.
         * If so, the value of <code>IsTruncated</code> is <code>true</code>. To get more values, submit another request
         * and include the values of <code>NextContinentCode</code>, <code>NextCountryCode</code>, and
         * <code>NextSubdivisionCode</code> in the <code>StartContinentCode</code>, <code>StartCountryCode</code>, and
         * <code>StartSubdivisionCode</code>, as applicable.
         * </p>
         * 
         * @param isTruncated
         *        A value that indicates whether more locations remain to be listed after the last location in this
         *        response. If so, the value of <code>IsTruncated</code> is <code>true</code>. To get more values,
         *        submit another request and include the values of <code>NextContinentCode</code>,
         *        <code>NextCountryCode</code>, and <code>NextSubdivisionCode</code> in the
         *        <code>StartContinentCode</code>, <code>StartCountryCode</code>, and <code>StartSubdivisionCode</code>,
         *        as applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isTruncated(Boolean isTruncated);

        /**
         * <p>
         * If <code>IsTruncated</code> is <code>true</code>, you can make a follow-up request to display more locations.
         * Enter the value of <code>NextContinentCode</code> in the <code>StartContinentCode</code> parameter in another
         * <code>ListGeoLocations</code> request.
         * </p>
         * 
         * @param nextContinentCode
         *        If <code>IsTruncated</code> is <code>true</code>, you can make a follow-up request to display more
         *        locations. Enter the value of <code>NextContinentCode</code> in the <code>StartContinentCode</code>
         *        parameter in another <code>ListGeoLocations</code> request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextContinentCode(String nextContinentCode);

        /**
         * <p>
         * If <code>IsTruncated</code> is <code>true</code>, you can make a follow-up request to display more locations.
         * Enter the value of <code>NextCountryCode</code> in the <code>StartCountryCode</code> parameter in another
         * <code>ListGeoLocations</code> request.
         * </p>
         * 
         * @param nextCountryCode
         *        If <code>IsTruncated</code> is <code>true</code>, you can make a follow-up request to display more
         *        locations. Enter the value of <code>NextCountryCode</code> in the <code>StartCountryCode</code>
         *        parameter in another <code>ListGeoLocations</code> request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextCountryCode(String nextCountryCode);

        /**
         * <p>
         * If <code>IsTruncated</code> is <code>true</code>, you can make a follow-up request to display more locations.
         * Enter the value of <code>NextSubdivisionCode</code> in the <code>StartSubdivisionCode</code> parameter in
         * another <code>ListGeoLocations</code> request.
         * </p>
         * 
         * @param nextSubdivisionCode
         *        If <code>IsTruncated</code> is <code>true</code>, you can make a follow-up request to display more
         *        locations. Enter the value of <code>NextSubdivisionCode</code> in the
         *        <code>StartSubdivisionCode</code> parameter in another <code>ListGeoLocations</code> request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextSubdivisionCode(String nextSubdivisionCode);

        /**
         * <p>
         * The value that you specified for <code>MaxItems</code> in the request.
         * </p>
         * 
         * @param maxItems
         *        The value that you specified for <code>MaxItems</code> in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxItems(String maxItems);
    }

    static final class BuilderImpl extends Route53Response.BuilderImpl implements Builder {
        private List<GeoLocationDetails> geoLocationDetailsList;

        private Boolean isTruncated;

        private String nextContinentCode;

        private String nextCountryCode;

        private String nextSubdivisionCode;

        private String maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(ListGeoLocationsResponse model) {
            geoLocationDetailsList(model.geoLocationDetailsList);
            isTruncated(model.isTruncated);
            nextContinentCode(model.nextContinentCode);
            nextCountryCode(model.nextCountryCode);
            nextSubdivisionCode(model.nextSubdivisionCode);
            maxItems(model.maxItems);
        }

        public final Collection<GeoLocationDetails.Builder> getGeoLocationDetailsList() {
            return geoLocationDetailsList != null ? geoLocationDetailsList.stream().map(GeoLocationDetails::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder geoLocationDetailsList(Collection<GeoLocationDetails> geoLocationDetailsList) {
            this.geoLocationDetailsList = GeoLocationDetailsListCopier.copy(geoLocationDetailsList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder geoLocationDetailsList(GeoLocationDetails... geoLocationDetailsList) {
            geoLocationDetailsList(Arrays.asList(geoLocationDetailsList));
            return this;
        }

        public final void setGeoLocationDetailsList(Collection<GeoLocationDetails.BuilderImpl> geoLocationDetailsList) {
            this.geoLocationDetailsList = GeoLocationDetailsListCopier.copyFromBuilder(geoLocationDetailsList);
        }

        public final Boolean getIsTruncated() {
            return isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        public final String getNextContinentCode() {
            return nextContinentCode;
        }

        @Override
        public final Builder nextContinentCode(String nextContinentCode) {
            this.nextContinentCode = nextContinentCode;
            return this;
        }

        public final void setNextContinentCode(String nextContinentCode) {
            this.nextContinentCode = nextContinentCode;
        }

        public final String getNextCountryCode() {
            return nextCountryCode;
        }

        @Override
        public final Builder nextCountryCode(String nextCountryCode) {
            this.nextCountryCode = nextCountryCode;
            return this;
        }

        public final void setNextCountryCode(String nextCountryCode) {
            this.nextCountryCode = nextCountryCode;
        }

        public final String getNextSubdivisionCode() {
            return nextSubdivisionCode;
        }

        @Override
        public final Builder nextSubdivisionCode(String nextSubdivisionCode) {
            this.nextSubdivisionCode = nextSubdivisionCode;
            return this;
        }

        public final void setNextSubdivisionCode(String nextSubdivisionCode) {
            this.nextSubdivisionCode = nextSubdivisionCode;
        }

        public final String getMaxItems() {
            return maxItems;
        }

        @Override
        public final Builder maxItems(String maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final void setMaxItems(String maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public ListGeoLocationsResponse build() {
            return new ListGeoLocationsResponse(this);
        }
    }
}
