/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains list information for the resource record set.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListResourceRecordSetsResponse extends Route53Response implements
        ToCopyableBuilder<ListResourceRecordSetsResponse.Builder, ListResourceRecordSetsResponse> {
    private final List<ResourceRecordSet> resourceRecordSets;

    private final Boolean isTruncated;

    private final String nextRecordName;

    private final String nextRecordType;

    private final String nextRecordIdentifier;

    private final String maxItems;

    private ListResourceRecordSetsResponse(BuilderImpl builder) {
        super(builder);
        this.resourceRecordSets = builder.resourceRecordSets;
        this.isTruncated = builder.isTruncated;
        this.nextRecordName = builder.nextRecordName;
        this.nextRecordType = builder.nextRecordType;
        this.nextRecordIdentifier = builder.nextRecordIdentifier;
        this.maxItems = builder.maxItems;
    }

    /**
     * <p>
     * Information about multiple resource record sets.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about multiple resource record sets.
     */
    public List<ResourceRecordSet> resourceRecordSets() {
        return resourceRecordSets;
    }

    /**
     * <p>
     * A flag that indicates whether more resource record sets remain to be listed. If your results were truncated, you
     * can make a follow-up pagination request by using the <code>NextRecordName</code> element.
     * </p>
     * 
     * @return A flag that indicates whether more resource record sets remain to be listed. If your results were
     *         truncated, you can make a follow-up pagination request by using the <code>NextRecordName</code> element.
     */
    public Boolean isTruncated() {
        return isTruncated;
    }

    /**
     * <p>
     * If the results were truncated, the name of the next record in the list.
     * </p>
     * <p>
     * This element is present only if <code>IsTruncated</code> is true.
     * </p>
     * 
     * @return If the results were truncated, the name of the next record in the list.</p>
     *         <p>
     *         This element is present only if <code>IsTruncated</code> is true.
     */
    public String nextRecordName() {
        return nextRecordName;
    }

    /**
     * <p>
     * If the results were truncated, the type of the next record in the list.
     * </p>
     * <p>
     * This element is present only if <code>IsTruncated</code> is true.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #nextRecordType}
     * will return {@link RRType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nextRecordTypeString}.
     * </p>
     * 
     * @return If the results were truncated, the type of the next record in the list.</p>
     *         <p>
     *         This element is present only if <code>IsTruncated</code> is true.
     * @see RRType
     */
    public RRType nextRecordType() {
        return RRType.fromValue(nextRecordType);
    }

    /**
     * <p>
     * If the results were truncated, the type of the next record in the list.
     * </p>
     * <p>
     * This element is present only if <code>IsTruncated</code> is true.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #nextRecordType}
     * will return {@link RRType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nextRecordTypeString}.
     * </p>
     * 
     * @return If the results were truncated, the type of the next record in the list.</p>
     *         <p>
     *         This element is present only if <code>IsTruncated</code> is true.
     * @see RRType
     */
    public String nextRecordTypeString() {
        return nextRecordType;
    }

    /**
     * <p>
     * <i>Weighted, latency, geolocation, and failover resource record sets only</i>: If results were truncated for a
     * given DNS name and type, the value of <code>SetIdentifier</code> for the next resource record set that has the
     * current DNS name and type.
     * </p>
     * 
     * @return <i>Weighted, latency, geolocation, and failover resource record sets only</i>: If results were truncated
     *         for a given DNS name and type, the value of <code>SetIdentifier</code> for the next resource record set
     *         that has the current DNS name and type.
     */
    public String nextRecordIdentifier() {
        return nextRecordIdentifier;
    }

    /**
     * <p>
     * The maximum number of records you requested.
     * </p>
     * 
     * @return The maximum number of records you requested.
     */
    public String maxItems() {
        return maxItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceRecordSets());
        hashCode = 31 * hashCode + Objects.hashCode(isTruncated());
        hashCode = 31 * hashCode + Objects.hashCode(nextRecordName());
        hashCode = 31 * hashCode + Objects.hashCode(nextRecordTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(nextRecordIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(maxItems());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListResourceRecordSetsResponse)) {
            return false;
        }
        ListResourceRecordSetsResponse other = (ListResourceRecordSetsResponse) obj;
        return Objects.equals(resourceRecordSets(), other.resourceRecordSets())
                && Objects.equals(isTruncated(), other.isTruncated()) && Objects.equals(nextRecordName(), other.nextRecordName())
                && Objects.equals(nextRecordTypeString(), other.nextRecordTypeString())
                && Objects.equals(nextRecordIdentifier(), other.nextRecordIdentifier())
                && Objects.equals(maxItems(), other.maxItems());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (resourceRecordSets() != null) {
            sb.append("ResourceRecordSets: ").append(resourceRecordSets()).append(",");
        }
        if (isTruncated() != null) {
            sb.append("IsTruncated: ").append(isTruncated()).append(",");
        }
        if (nextRecordName() != null) {
            sb.append("NextRecordName: ").append(nextRecordName()).append(",");
        }
        if (nextRecordTypeString() != null) {
            sb.append("NextRecordType: ").append(nextRecordTypeString()).append(",");
        }
        if (nextRecordIdentifier() != null) {
            sb.append("NextRecordIdentifier: ").append(nextRecordIdentifier()).append(",");
        }
        if (maxItems() != null) {
            sb.append("MaxItems: ").append(maxItems()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceRecordSets":
            return Optional.of(clazz.cast(resourceRecordSets()));
        case "IsTruncated":
            return Optional.of(clazz.cast(isTruncated()));
        case "NextRecordName":
            return Optional.of(clazz.cast(nextRecordName()));
        case "NextRecordType":
            return Optional.of(clazz.cast(nextRecordTypeString()));
        case "NextRecordIdentifier":
            return Optional.of(clazz.cast(nextRecordIdentifier()));
        case "MaxItems":
            return Optional.of(clazz.cast(maxItems()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends Route53Response.Builder, CopyableBuilder<Builder, ListResourceRecordSetsResponse> {
        /**
         * <p>
         * Information about multiple resource record sets.
         * </p>
         * 
         * @param resourceRecordSets
         *        Information about multiple resource record sets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceRecordSets(Collection<ResourceRecordSet> resourceRecordSets);

        /**
         * <p>
         * Information about multiple resource record sets.
         * </p>
         * 
         * @param resourceRecordSets
         *        Information about multiple resource record sets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceRecordSets(ResourceRecordSet... resourceRecordSets);

        /**
         * <p>
         * A flag that indicates whether more resource record sets remain to be listed. If your results were truncated,
         * you can make a follow-up pagination request by using the <code>NextRecordName</code> element.
         * </p>
         * 
         * @param isTruncated
         *        A flag that indicates whether more resource record sets remain to be listed. If your results were
         *        truncated, you can make a follow-up pagination request by using the <code>NextRecordName</code>
         *        element.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isTruncated(Boolean isTruncated);

        /**
         * <p>
         * If the results were truncated, the name of the next record in the list.
         * </p>
         * <p>
         * This element is present only if <code>IsTruncated</code> is true.
         * </p>
         * 
         * @param nextRecordName
         *        If the results were truncated, the name of the next record in the list.</p>
         *        <p>
         *        This element is present only if <code>IsTruncated</code> is true.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextRecordName(String nextRecordName);

        /**
         * <p>
         * If the results were truncated, the type of the next record in the list.
         * </p>
         * <p>
         * This element is present only if <code>IsTruncated</code> is true.
         * </p>
         * 
         * @param nextRecordType
         *        If the results were truncated, the type of the next record in the list.</p>
         *        <p>
         *        This element is present only if <code>IsTruncated</code> is true.
         * @see RRType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RRType
         */
        Builder nextRecordType(String nextRecordType);

        /**
         * <p>
         * If the results were truncated, the type of the next record in the list.
         * </p>
         * <p>
         * This element is present only if <code>IsTruncated</code> is true.
         * </p>
         * 
         * @param nextRecordType
         *        If the results were truncated, the type of the next record in the list.</p>
         *        <p>
         *        This element is present only if <code>IsTruncated</code> is true.
         * @see RRType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RRType
         */
        Builder nextRecordType(RRType nextRecordType);

        /**
         * <p>
         * <i>Weighted, latency, geolocation, and failover resource record sets only</i>: If results were truncated for
         * a given DNS name and type, the value of <code>SetIdentifier</code> for the next resource record set that has
         * the current DNS name and type.
         * </p>
         * 
         * @param nextRecordIdentifier
         *        <i>Weighted, latency, geolocation, and failover resource record sets only</i>: If results were
         *        truncated for a given DNS name and type, the value of <code>SetIdentifier</code> for the next resource
         *        record set that has the current DNS name and type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextRecordIdentifier(String nextRecordIdentifier);

        /**
         * <p>
         * The maximum number of records you requested.
         * </p>
         * 
         * @param maxItems
         *        The maximum number of records you requested.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxItems(String maxItems);
    }

    static final class BuilderImpl extends Route53Response.BuilderImpl implements Builder {
        private List<ResourceRecordSet> resourceRecordSets;

        private Boolean isTruncated;

        private String nextRecordName;

        private String nextRecordType;

        private String nextRecordIdentifier;

        private String maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(ListResourceRecordSetsResponse model) {
            resourceRecordSets(model.resourceRecordSets);
            isTruncated(model.isTruncated);
            nextRecordName(model.nextRecordName);
            nextRecordType(model.nextRecordType);
            nextRecordIdentifier(model.nextRecordIdentifier);
            maxItems(model.maxItems);
        }

        public final Collection<ResourceRecordSet.Builder> getResourceRecordSets() {
            return resourceRecordSets != null ? resourceRecordSets.stream().map(ResourceRecordSet::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder resourceRecordSets(Collection<ResourceRecordSet> resourceRecordSets) {
            this.resourceRecordSets = ResourceRecordSetsCopier.copy(resourceRecordSets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceRecordSets(ResourceRecordSet... resourceRecordSets) {
            resourceRecordSets(Arrays.asList(resourceRecordSets));
            return this;
        }

        public final void setResourceRecordSets(Collection<ResourceRecordSet.BuilderImpl> resourceRecordSets) {
            this.resourceRecordSets = ResourceRecordSetsCopier.copyFromBuilder(resourceRecordSets);
        }

        public final Boolean getIsTruncated() {
            return isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        public final String getNextRecordName() {
            return nextRecordName;
        }

        @Override
        public final Builder nextRecordName(String nextRecordName) {
            this.nextRecordName = nextRecordName;
            return this;
        }

        public final void setNextRecordName(String nextRecordName) {
            this.nextRecordName = nextRecordName;
        }

        public final String getNextRecordType() {
            return nextRecordType;
        }

        @Override
        public final Builder nextRecordType(String nextRecordType) {
            this.nextRecordType = nextRecordType;
            return this;
        }

        @Override
        public final Builder nextRecordType(RRType nextRecordType) {
            this.nextRecordType(nextRecordType.toString());
            return this;
        }

        public final void setNextRecordType(String nextRecordType) {
            this.nextRecordType = nextRecordType;
        }

        public final String getNextRecordIdentifier() {
            return nextRecordIdentifier;
        }

        @Override
        public final Builder nextRecordIdentifier(String nextRecordIdentifier) {
            this.nextRecordIdentifier = nextRecordIdentifier;
            return this;
        }

        public final void setNextRecordIdentifier(String nextRecordIdentifier) {
            this.nextRecordIdentifier = nextRecordIdentifier;
        }

        public final String getMaxItems() {
            return maxItems;
        }

        @Override
        public final Builder maxItems(String maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final void setMaxItems(String maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public ListResourceRecordSetsResponse build() {
            return new ListResourceRecordSetsResponse(this);
        }
    }
}
