/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains the response information for the request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListTrafficPoliciesResponse extends Route53Response implements
        ToCopyableBuilder<ListTrafficPoliciesResponse.Builder, ListTrafficPoliciesResponse> {
    private final List<TrafficPolicySummary> trafficPolicySummaries;

    private final Boolean isTruncated;

    private final String trafficPolicyIdMarker;

    private final String maxItems;

    private ListTrafficPoliciesResponse(BuilderImpl builder) {
        super(builder);
        this.trafficPolicySummaries = builder.trafficPolicySummaries;
        this.isTruncated = builder.isTruncated;
        this.trafficPolicyIdMarker = builder.trafficPolicyIdMarker;
        this.maxItems = builder.maxItems;
    }

    /**
     * <p>
     * A list that contains one <code>TrafficPolicySummary</code> element for each traffic policy that was created by
     * the current AWS account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list that contains one <code>TrafficPolicySummary</code> element for each traffic policy that was
     *         created by the current AWS account.
     */
    public List<TrafficPolicySummary> trafficPolicySummaries() {
        return trafficPolicySummaries;
    }

    /**
     * <p>
     * A flag that indicates whether there are more traffic policies to be listed. If the response was truncated, you
     * can get the next group of traffic policies by submitting another <code>ListTrafficPolicies</code> request and
     * specifying the value of <code>TrafficPolicyIdMarker</code> in the <code>TrafficPolicyIdMarker</code> request
     * parameter.
     * </p>
     * 
     * @return A flag that indicates whether there are more traffic policies to be listed. If the response was
     *         truncated, you can get the next group of traffic policies by submitting another
     *         <code>ListTrafficPolicies</code> request and specifying the value of <code>TrafficPolicyIdMarker</code>
     *         in the <code>TrafficPolicyIdMarker</code> request parameter.
     */
    public Boolean isTruncated() {
        return isTruncated;
    }

    /**
     * <p>
     * If the value of <code>IsTruncated</code> is <code>true</code>, <code>TrafficPolicyIdMarker</code> is the ID of
     * the first traffic policy in the next group of <code>MaxItems</code> traffic policies.
     * </p>
     * 
     * @return If the value of <code>IsTruncated</code> is <code>true</code>, <code>TrafficPolicyIdMarker</code> is the
     *         ID of the first traffic policy in the next group of <code>MaxItems</code> traffic policies.
     */
    public String trafficPolicyIdMarker() {
        return trafficPolicyIdMarker;
    }

    /**
     * <p>
     * The value that you specified for the <code>MaxItems</code> parameter in the <code>ListTrafficPolicies</code>
     * request that produced the current response.
     * </p>
     * 
     * @return The value that you specified for the <code>MaxItems</code> parameter in the
     *         <code>ListTrafficPolicies</code> request that produced the current response.
     */
    public String maxItems() {
        return maxItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(trafficPolicySummaries());
        hashCode = 31 * hashCode + Objects.hashCode(isTruncated());
        hashCode = 31 * hashCode + Objects.hashCode(trafficPolicyIdMarker());
        hashCode = 31 * hashCode + Objects.hashCode(maxItems());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTrafficPoliciesResponse)) {
            return false;
        }
        ListTrafficPoliciesResponse other = (ListTrafficPoliciesResponse) obj;
        return Objects.equals(trafficPolicySummaries(), other.trafficPolicySummaries())
                && Objects.equals(isTruncated(), other.isTruncated())
                && Objects.equals(trafficPolicyIdMarker(), other.trafficPolicyIdMarker())
                && Objects.equals(maxItems(), other.maxItems());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (trafficPolicySummaries() != null) {
            sb.append("TrafficPolicySummaries: ").append(trafficPolicySummaries()).append(",");
        }
        if (isTruncated() != null) {
            sb.append("IsTruncated: ").append(isTruncated()).append(",");
        }
        if (trafficPolicyIdMarker() != null) {
            sb.append("TrafficPolicyIdMarker: ").append(trafficPolicyIdMarker()).append(",");
        }
        if (maxItems() != null) {
            sb.append("MaxItems: ").append(maxItems()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TrafficPolicySummaries":
            return Optional.of(clazz.cast(trafficPolicySummaries()));
        case "IsTruncated":
            return Optional.of(clazz.cast(isTruncated()));
        case "TrafficPolicyIdMarker":
            return Optional.of(clazz.cast(trafficPolicyIdMarker()));
        case "MaxItems":
            return Optional.of(clazz.cast(maxItems()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends Route53Response.Builder, CopyableBuilder<Builder, ListTrafficPoliciesResponse> {
        /**
         * <p>
         * A list that contains one <code>TrafficPolicySummary</code> element for each traffic policy that was created
         * by the current AWS account.
         * </p>
         * 
         * @param trafficPolicySummaries
         *        A list that contains one <code>TrafficPolicySummary</code> element for each traffic policy that was
         *        created by the current AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trafficPolicySummaries(Collection<TrafficPolicySummary> trafficPolicySummaries);

        /**
         * <p>
         * A list that contains one <code>TrafficPolicySummary</code> element for each traffic policy that was created
         * by the current AWS account.
         * </p>
         * 
         * @param trafficPolicySummaries
         *        A list that contains one <code>TrafficPolicySummary</code> element for each traffic policy that was
         *        created by the current AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trafficPolicySummaries(TrafficPolicySummary... trafficPolicySummaries);

        /**
         * <p>
         * A flag that indicates whether there are more traffic policies to be listed. If the response was truncated,
         * you can get the next group of traffic policies by submitting another <code>ListTrafficPolicies</code> request
         * and specifying the value of <code>TrafficPolicyIdMarker</code> in the <code>TrafficPolicyIdMarker</code>
         * request parameter.
         * </p>
         * 
         * @param isTruncated
         *        A flag that indicates whether there are more traffic policies to be listed. If the response was
         *        truncated, you can get the next group of traffic policies by submitting another
         *        <code>ListTrafficPolicies</code> request and specifying the value of
         *        <code>TrafficPolicyIdMarker</code> in the <code>TrafficPolicyIdMarker</code> request parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isTruncated(Boolean isTruncated);

        /**
         * <p>
         * If the value of <code>IsTruncated</code> is <code>true</code>, <code>TrafficPolicyIdMarker</code> is the ID
         * of the first traffic policy in the next group of <code>MaxItems</code> traffic policies.
         * </p>
         * 
         * @param trafficPolicyIdMarker
         *        If the value of <code>IsTruncated</code> is <code>true</code>, <code>TrafficPolicyIdMarker</code> is
         *        the ID of the first traffic policy in the next group of <code>MaxItems</code> traffic policies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trafficPolicyIdMarker(String trafficPolicyIdMarker);

        /**
         * <p>
         * The value that you specified for the <code>MaxItems</code> parameter in the <code>ListTrafficPolicies</code>
         * request that produced the current response.
         * </p>
         * 
         * @param maxItems
         *        The value that you specified for the <code>MaxItems</code> parameter in the
         *        <code>ListTrafficPolicies</code> request that produced the current response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxItems(String maxItems);
    }

    static final class BuilderImpl extends Route53Response.BuilderImpl implements Builder {
        private List<TrafficPolicySummary> trafficPolicySummaries;

        private Boolean isTruncated;

        private String trafficPolicyIdMarker;

        private String maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTrafficPoliciesResponse model) {
            trafficPolicySummaries(model.trafficPolicySummaries);
            isTruncated(model.isTruncated);
            trafficPolicyIdMarker(model.trafficPolicyIdMarker);
            maxItems(model.maxItems);
        }

        public final Collection<TrafficPolicySummary.Builder> getTrafficPolicySummaries() {
            return trafficPolicySummaries != null ? trafficPolicySummaries.stream().map(TrafficPolicySummary::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder trafficPolicySummaries(Collection<TrafficPolicySummary> trafficPolicySummaries) {
            this.trafficPolicySummaries = TrafficPolicySummariesCopier.copy(trafficPolicySummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trafficPolicySummaries(TrafficPolicySummary... trafficPolicySummaries) {
            trafficPolicySummaries(Arrays.asList(trafficPolicySummaries));
            return this;
        }

        public final void setTrafficPolicySummaries(Collection<TrafficPolicySummary.BuilderImpl> trafficPolicySummaries) {
            this.trafficPolicySummaries = TrafficPolicySummariesCopier.copyFromBuilder(trafficPolicySummaries);
        }

        public final Boolean getIsTruncated() {
            return isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        public final String getTrafficPolicyIdMarker() {
            return trafficPolicyIdMarker;
        }

        @Override
        public final Builder trafficPolicyIdMarker(String trafficPolicyIdMarker) {
            this.trafficPolicyIdMarker = trafficPolicyIdMarker;
            return this;
        }

        public final void setTrafficPolicyIdMarker(String trafficPolicyIdMarker) {
            this.trafficPolicyIdMarker = trafficPolicyIdMarker;
        }

        public final String getMaxItems() {
            return maxItems;
        }

        @Override
        public final Builder maxItems(String maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final void setMaxItems(String maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public ListTrafficPoliciesResponse build() {
            return new ListTrafficPoliciesResponse(this);
        }
    }
}
