/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains the response information for the request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListTrafficPolicyInstancesByPolicyResponse extends Route53Response implements
        ToCopyableBuilder<ListTrafficPolicyInstancesByPolicyResponse.Builder, ListTrafficPolicyInstancesByPolicyResponse> {
    private final List<TrafficPolicyInstance> trafficPolicyInstances;

    private final String hostedZoneIdMarker;

    private final String trafficPolicyInstanceNameMarker;

    private final String trafficPolicyInstanceTypeMarker;

    private final Boolean isTruncated;

    private final String maxItems;

    private ListTrafficPolicyInstancesByPolicyResponse(BuilderImpl builder) {
        super(builder);
        this.trafficPolicyInstances = builder.trafficPolicyInstances;
        this.hostedZoneIdMarker = builder.hostedZoneIdMarker;
        this.trafficPolicyInstanceNameMarker = builder.trafficPolicyInstanceNameMarker;
        this.trafficPolicyInstanceTypeMarker = builder.trafficPolicyInstanceTypeMarker;
        this.isTruncated = builder.isTruncated;
        this.maxItems = builder.maxItems;
    }

    /**
     * <p>
     * A list that contains one <code>TrafficPolicyInstance</code> element for each traffic policy instance that matches
     * the elements in the request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list that contains one <code>TrafficPolicyInstance</code> element for each traffic policy instance that
     *         matches the elements in the request.
     */
    public List<TrafficPolicyInstance> trafficPolicyInstances() {
        return trafficPolicyInstances;
    }

    /**
     * <p>
     * If <code>IsTruncated</code> is <code>true</code>, <code>HostedZoneIdMarker</code> is the ID of the hosted zone of
     * the first traffic policy instance in the next group of traffic policy instances.
     * </p>
     * 
     * @return If <code>IsTruncated</code> is <code>true</code>, <code>HostedZoneIdMarker</code> is the ID of the hosted
     *         zone of the first traffic policy instance in the next group of traffic policy instances.
     */
    public String hostedZoneIdMarker() {
        return hostedZoneIdMarker;
    }

    /**
     * <p>
     * If <code>IsTruncated</code> is <code>true</code>, <code>TrafficPolicyInstanceNameMarker</code> is the name of the
     * first traffic policy instance in the next group of <code>MaxItems</code> traffic policy instances.
     * </p>
     * 
     * @return If <code>IsTruncated</code> is <code>true</code>, <code>TrafficPolicyInstanceNameMarker</code> is the
     *         name of the first traffic policy instance in the next group of <code>MaxItems</code> traffic policy
     *         instances.
     */
    public String trafficPolicyInstanceNameMarker() {
        return trafficPolicyInstanceNameMarker;
    }

    /**
     * <p>
     * If <code>IsTruncated</code> is <code>true</code>, <code>TrafficPolicyInstanceTypeMarker</code> is the DNS type of
     * the resource record sets that are associated with the first traffic policy instance in the next group of
     * <code>MaxItems</code> traffic policy instances.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #trafficPolicyInstanceTypeMarker} will return {@link RRType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #trafficPolicyInstanceTypeMarkerString}.
     * </p>
     * 
     * @return If <code>IsTruncated</code> is <code>true</code>, <code>TrafficPolicyInstanceTypeMarker</code> is the DNS
     *         type of the resource record sets that are associated with the first traffic policy instance in the next
     *         group of <code>MaxItems</code> traffic policy instances.
     * @see RRType
     */
    public RRType trafficPolicyInstanceTypeMarker() {
        return RRType.fromValue(trafficPolicyInstanceTypeMarker);
    }

    /**
     * <p>
     * If <code>IsTruncated</code> is <code>true</code>, <code>TrafficPolicyInstanceTypeMarker</code> is the DNS type of
     * the resource record sets that are associated with the first traffic policy instance in the next group of
     * <code>MaxItems</code> traffic policy instances.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #trafficPolicyInstanceTypeMarker} will return {@link RRType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #trafficPolicyInstanceTypeMarkerString}.
     * </p>
     * 
     * @return If <code>IsTruncated</code> is <code>true</code>, <code>TrafficPolicyInstanceTypeMarker</code> is the DNS
     *         type of the resource record sets that are associated with the first traffic policy instance in the next
     *         group of <code>MaxItems</code> traffic policy instances.
     * @see RRType
     */
    public String trafficPolicyInstanceTypeMarkerString() {
        return trafficPolicyInstanceTypeMarker;
    }

    /**
     * <p>
     * A flag that indicates whether there are more traffic policy instances to be listed. If the response was
     * truncated, you can get the next group of traffic policy instances by calling
     * <code>ListTrafficPolicyInstancesByPolicy</code> again and specifying the values of the
     * <code>HostedZoneIdMarker</code>, <code>TrafficPolicyInstanceNameMarker</code>, and
     * <code>TrafficPolicyInstanceTypeMarker</code> elements in the corresponding request parameters.
     * </p>
     * 
     * @return A flag that indicates whether there are more traffic policy instances to be listed. If the response was
     *         truncated, you can get the next group of traffic policy instances by calling
     *         <code>ListTrafficPolicyInstancesByPolicy</code> again and specifying the values of the
     *         <code>HostedZoneIdMarker</code>, <code>TrafficPolicyInstanceNameMarker</code>, and
     *         <code>TrafficPolicyInstanceTypeMarker</code> elements in the corresponding request parameters.
     */
    public Boolean isTruncated() {
        return isTruncated;
    }

    /**
     * <p>
     * The value that you specified for the <code>MaxItems</code> parameter in the call to
     * <code>ListTrafficPolicyInstancesByPolicy</code> that produced the current response.
     * </p>
     * 
     * @return The value that you specified for the <code>MaxItems</code> parameter in the call to
     *         <code>ListTrafficPolicyInstancesByPolicy</code> that produced the current response.
     */
    public String maxItems() {
        return maxItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(trafficPolicyInstances());
        hashCode = 31 * hashCode + Objects.hashCode(hostedZoneIdMarker());
        hashCode = 31 * hashCode + Objects.hashCode(trafficPolicyInstanceNameMarker());
        hashCode = 31 * hashCode + Objects.hashCode(trafficPolicyInstanceTypeMarkerString());
        hashCode = 31 * hashCode + Objects.hashCode(isTruncated());
        hashCode = 31 * hashCode + Objects.hashCode(maxItems());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTrafficPolicyInstancesByPolicyResponse)) {
            return false;
        }
        ListTrafficPolicyInstancesByPolicyResponse other = (ListTrafficPolicyInstancesByPolicyResponse) obj;
        return Objects.equals(trafficPolicyInstances(), other.trafficPolicyInstances())
                && Objects.equals(hostedZoneIdMarker(), other.hostedZoneIdMarker())
                && Objects.equals(trafficPolicyInstanceNameMarker(), other.trafficPolicyInstanceNameMarker())
                && Objects.equals(trafficPolicyInstanceTypeMarkerString(), other.trafficPolicyInstanceTypeMarkerString())
                && Objects.equals(isTruncated(), other.isTruncated()) && Objects.equals(maxItems(), other.maxItems());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (trafficPolicyInstances() != null) {
            sb.append("TrafficPolicyInstances: ").append(trafficPolicyInstances()).append(",");
        }
        if (hostedZoneIdMarker() != null) {
            sb.append("HostedZoneIdMarker: ").append(hostedZoneIdMarker()).append(",");
        }
        if (trafficPolicyInstanceNameMarker() != null) {
            sb.append("TrafficPolicyInstanceNameMarker: ").append(trafficPolicyInstanceNameMarker()).append(",");
        }
        if (trafficPolicyInstanceTypeMarkerString() != null) {
            sb.append("TrafficPolicyInstanceTypeMarker: ").append(trafficPolicyInstanceTypeMarkerString()).append(",");
        }
        if (isTruncated() != null) {
            sb.append("IsTruncated: ").append(isTruncated()).append(",");
        }
        if (maxItems() != null) {
            sb.append("MaxItems: ").append(maxItems()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TrafficPolicyInstances":
            return Optional.of(clazz.cast(trafficPolicyInstances()));
        case "HostedZoneIdMarker":
            return Optional.of(clazz.cast(hostedZoneIdMarker()));
        case "TrafficPolicyInstanceNameMarker":
            return Optional.of(clazz.cast(trafficPolicyInstanceNameMarker()));
        case "TrafficPolicyInstanceTypeMarker":
            return Optional.of(clazz.cast(trafficPolicyInstanceTypeMarkerString()));
        case "IsTruncated":
            return Optional.of(clazz.cast(isTruncated()));
        case "MaxItems":
            return Optional.of(clazz.cast(maxItems()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends Route53Response.Builder,
            CopyableBuilder<Builder, ListTrafficPolicyInstancesByPolicyResponse> {
        /**
         * <p>
         * A list that contains one <code>TrafficPolicyInstance</code> element for each traffic policy instance that
         * matches the elements in the request.
         * </p>
         * 
         * @param trafficPolicyInstances
         *        A list that contains one <code>TrafficPolicyInstance</code> element for each traffic policy instance
         *        that matches the elements in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trafficPolicyInstances(Collection<TrafficPolicyInstance> trafficPolicyInstances);

        /**
         * <p>
         * A list that contains one <code>TrafficPolicyInstance</code> element for each traffic policy instance that
         * matches the elements in the request.
         * </p>
         * 
         * @param trafficPolicyInstances
         *        A list that contains one <code>TrafficPolicyInstance</code> element for each traffic policy instance
         *        that matches the elements in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trafficPolicyInstances(TrafficPolicyInstance... trafficPolicyInstances);

        /**
         * <p>
         * If <code>IsTruncated</code> is <code>true</code>, <code>HostedZoneIdMarker</code> is the ID of the hosted
         * zone of the first traffic policy instance in the next group of traffic policy instances.
         * </p>
         * 
         * @param hostedZoneIdMarker
         *        If <code>IsTruncated</code> is <code>true</code>, <code>HostedZoneIdMarker</code> is the ID of the
         *        hosted zone of the first traffic policy instance in the next group of traffic policy instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostedZoneIdMarker(String hostedZoneIdMarker);

        /**
         * <p>
         * If <code>IsTruncated</code> is <code>true</code>, <code>TrafficPolicyInstanceNameMarker</code> is the name of
         * the first traffic policy instance in the next group of <code>MaxItems</code> traffic policy instances.
         * </p>
         * 
         * @param trafficPolicyInstanceNameMarker
         *        If <code>IsTruncated</code> is <code>true</code>, <code>TrafficPolicyInstanceNameMarker</code> is the
         *        name of the first traffic policy instance in the next group of <code>MaxItems</code> traffic policy
         *        instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trafficPolicyInstanceNameMarker(String trafficPolicyInstanceNameMarker);

        /**
         * <p>
         * If <code>IsTruncated</code> is <code>true</code>, <code>TrafficPolicyInstanceTypeMarker</code> is the DNS
         * type of the resource record sets that are associated with the first traffic policy instance in the next group
         * of <code>MaxItems</code> traffic policy instances.
         * </p>
         * 
         * @param trafficPolicyInstanceTypeMarker
         *        If <code>IsTruncated</code> is <code>true</code>, <code>TrafficPolicyInstanceTypeMarker</code> is the
         *        DNS type of the resource record sets that are associated with the first traffic policy instance in the
         *        next group of <code>MaxItems</code> traffic policy instances.
         * @see RRType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RRType
         */
        Builder trafficPolicyInstanceTypeMarker(String trafficPolicyInstanceTypeMarker);

        /**
         * <p>
         * If <code>IsTruncated</code> is <code>true</code>, <code>TrafficPolicyInstanceTypeMarker</code> is the DNS
         * type of the resource record sets that are associated with the first traffic policy instance in the next group
         * of <code>MaxItems</code> traffic policy instances.
         * </p>
         * 
         * @param trafficPolicyInstanceTypeMarker
         *        If <code>IsTruncated</code> is <code>true</code>, <code>TrafficPolicyInstanceTypeMarker</code> is the
         *        DNS type of the resource record sets that are associated with the first traffic policy instance in the
         *        next group of <code>MaxItems</code> traffic policy instances.
         * @see RRType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RRType
         */
        Builder trafficPolicyInstanceTypeMarker(RRType trafficPolicyInstanceTypeMarker);

        /**
         * <p>
         * A flag that indicates whether there are more traffic policy instances to be listed. If the response was
         * truncated, you can get the next group of traffic policy instances by calling
         * <code>ListTrafficPolicyInstancesByPolicy</code> again and specifying the values of the
         * <code>HostedZoneIdMarker</code>, <code>TrafficPolicyInstanceNameMarker</code>, and
         * <code>TrafficPolicyInstanceTypeMarker</code> elements in the corresponding request parameters.
         * </p>
         * 
         * @param isTruncated
         *        A flag that indicates whether there are more traffic policy instances to be listed. If the response
         *        was truncated, you can get the next group of traffic policy instances by calling
         *        <code>ListTrafficPolicyInstancesByPolicy</code> again and specifying the values of the
         *        <code>HostedZoneIdMarker</code>, <code>TrafficPolicyInstanceNameMarker</code>, and
         *        <code>TrafficPolicyInstanceTypeMarker</code> elements in the corresponding request parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isTruncated(Boolean isTruncated);

        /**
         * <p>
         * The value that you specified for the <code>MaxItems</code> parameter in the call to
         * <code>ListTrafficPolicyInstancesByPolicy</code> that produced the current response.
         * </p>
         * 
         * @param maxItems
         *        The value that you specified for the <code>MaxItems</code> parameter in the call to
         *        <code>ListTrafficPolicyInstancesByPolicy</code> that produced the current response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxItems(String maxItems);
    }

    static final class BuilderImpl extends Route53Response.BuilderImpl implements Builder {
        private List<TrafficPolicyInstance> trafficPolicyInstances;

        private String hostedZoneIdMarker;

        private String trafficPolicyInstanceNameMarker;

        private String trafficPolicyInstanceTypeMarker;

        private Boolean isTruncated;

        private String maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTrafficPolicyInstancesByPolicyResponse model) {
            trafficPolicyInstances(model.trafficPolicyInstances);
            hostedZoneIdMarker(model.hostedZoneIdMarker);
            trafficPolicyInstanceNameMarker(model.trafficPolicyInstanceNameMarker);
            trafficPolicyInstanceTypeMarker(model.trafficPolicyInstanceTypeMarker);
            isTruncated(model.isTruncated);
            maxItems(model.maxItems);
        }

        public final Collection<TrafficPolicyInstance.Builder> getTrafficPolicyInstances() {
            return trafficPolicyInstances != null ? trafficPolicyInstances.stream().map(TrafficPolicyInstance::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder trafficPolicyInstances(Collection<TrafficPolicyInstance> trafficPolicyInstances) {
            this.trafficPolicyInstances = TrafficPolicyInstancesCopier.copy(trafficPolicyInstances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trafficPolicyInstances(TrafficPolicyInstance... trafficPolicyInstances) {
            trafficPolicyInstances(Arrays.asList(trafficPolicyInstances));
            return this;
        }

        public final void setTrafficPolicyInstances(Collection<TrafficPolicyInstance.BuilderImpl> trafficPolicyInstances) {
            this.trafficPolicyInstances = TrafficPolicyInstancesCopier.copyFromBuilder(trafficPolicyInstances);
        }

        public final String getHostedZoneIdMarker() {
            return hostedZoneIdMarker;
        }

        @Override
        public final Builder hostedZoneIdMarker(String hostedZoneIdMarker) {
            this.hostedZoneIdMarker = hostedZoneIdMarker;
            return this;
        }

        public final void setHostedZoneIdMarker(String hostedZoneIdMarker) {
            this.hostedZoneIdMarker = hostedZoneIdMarker;
        }

        public final String getTrafficPolicyInstanceNameMarker() {
            return trafficPolicyInstanceNameMarker;
        }

        @Override
        public final Builder trafficPolicyInstanceNameMarker(String trafficPolicyInstanceNameMarker) {
            this.trafficPolicyInstanceNameMarker = trafficPolicyInstanceNameMarker;
            return this;
        }

        public final void setTrafficPolicyInstanceNameMarker(String trafficPolicyInstanceNameMarker) {
            this.trafficPolicyInstanceNameMarker = trafficPolicyInstanceNameMarker;
        }

        public final String getTrafficPolicyInstanceTypeMarker() {
            return trafficPolicyInstanceTypeMarker;
        }

        @Override
        public final Builder trafficPolicyInstanceTypeMarker(String trafficPolicyInstanceTypeMarker) {
            this.trafficPolicyInstanceTypeMarker = trafficPolicyInstanceTypeMarker;
            return this;
        }

        @Override
        public final Builder trafficPolicyInstanceTypeMarker(RRType trafficPolicyInstanceTypeMarker) {
            this.trafficPolicyInstanceTypeMarker(trafficPolicyInstanceTypeMarker.toString());
            return this;
        }

        public final void setTrafficPolicyInstanceTypeMarker(String trafficPolicyInstanceTypeMarker) {
            this.trafficPolicyInstanceTypeMarker = trafficPolicyInstanceTypeMarker;
        }

        public final Boolean getIsTruncated() {
            return isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        public final String getMaxItems() {
            return maxItems;
        }

        @Override
        public final Builder maxItems(String maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final void setMaxItems(String maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public ListTrafficPolicyInstancesByPolicyResponse build() {
            return new ListTrafficPolicyInstancesByPolicyResponse(this);
        }
    }
}
