/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains information about the resource record sets that Amazon Route 53 created based on a
 * specified traffic policy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class UpdateTrafficPolicyInstanceResponse extends Route53Response implements
        ToCopyableBuilder<UpdateTrafficPolicyInstanceResponse.Builder, UpdateTrafficPolicyInstanceResponse> {
    private final TrafficPolicyInstance trafficPolicyInstance;

    private UpdateTrafficPolicyInstanceResponse(BuilderImpl builder) {
        super(builder);
        this.trafficPolicyInstance = builder.trafficPolicyInstance;
    }

    /**
     * <p>
     * A complex type that contains settings for the updated traffic policy instance.
     * </p>
     * 
     * @return A complex type that contains settings for the updated traffic policy instance.
     */
    public TrafficPolicyInstance trafficPolicyInstance() {
        return trafficPolicyInstance;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(trafficPolicyInstance());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTrafficPolicyInstanceResponse)) {
            return false;
        }
        UpdateTrafficPolicyInstanceResponse other = (UpdateTrafficPolicyInstanceResponse) obj;
        return Objects.equals(trafficPolicyInstance(), other.trafficPolicyInstance());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (trafficPolicyInstance() != null) {
            sb.append("TrafficPolicyInstance: ").append(trafficPolicyInstance()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TrafficPolicyInstance":
            return Optional.of(clazz.cast(trafficPolicyInstance()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends Route53Response.Builder, CopyableBuilder<Builder, UpdateTrafficPolicyInstanceResponse> {
        /**
         * <p>
         * A complex type that contains settings for the updated traffic policy instance.
         * </p>
         * 
         * @param trafficPolicyInstance
         *        A complex type that contains settings for the updated traffic policy instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trafficPolicyInstance(TrafficPolicyInstance trafficPolicyInstance);

        /**
         * <p>
         * A complex type that contains settings for the updated traffic policy instance.
         * </p>
         * This is a convenience that creates an instance of the {@link TrafficPolicyInstance.Builder} avoiding the need
         * to create one manually via {@link TrafficPolicyInstance#builder()}.
         *
         * When the {@link Consumer} completes, {@link TrafficPolicyInstance.Builder#build()} is called immediately and
         * its result is passed to {@link #trafficPolicyInstance(TrafficPolicyInstance)}.
         * 
         * @param trafficPolicyInstance
         *        a consumer that will call methods on {@link TrafficPolicyInstance.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trafficPolicyInstance(TrafficPolicyInstance)
         */
        default Builder trafficPolicyInstance(Consumer<TrafficPolicyInstance.Builder> trafficPolicyInstance) {
            return trafficPolicyInstance(TrafficPolicyInstance.builder().apply(trafficPolicyInstance).build());
        }
    }

    static final class BuilderImpl extends Route53Response.BuilderImpl implements Builder {
        private TrafficPolicyInstance trafficPolicyInstance;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTrafficPolicyInstanceResponse model) {
            trafficPolicyInstance(model.trafficPolicyInstance);
        }

        public final TrafficPolicyInstance.Builder getTrafficPolicyInstance() {
            return trafficPolicyInstance != null ? trafficPolicyInstance.toBuilder() : null;
        }

        @Override
        public final Builder trafficPolicyInstance(TrafficPolicyInstance trafficPolicyInstance) {
            this.trafficPolicyInstance = trafficPolicyInstance;
            return this;
        }

        public final void setTrafficPolicyInstance(TrafficPolicyInstance.BuilderImpl trafficPolicyInstance) {
            this.trafficPolicyInstance = trafficPolicyInstance != null ? trafficPolicyInstance.build() : null;
        }

        @Override
        public UpdateTrafficPolicyInstanceResponse build() {
            return new UpdateTrafficPolicyInstanceResponse(this);
        }
    }
}
