/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.route53.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;

import software.amazon.awssdk.core.util.StringUtils;

/**
 * ListQueryLoggingConfigsRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ListQueryLoggingConfigsRequestMarshaller implements
        Marshaller<Request<ListQueryLoggingConfigsRequest>, ListQueryLoggingConfigsRequest> {

    public Request<ListQueryLoggingConfigsRequest> marshall(ListQueryLoggingConfigsRequest listQueryLoggingConfigsRequest) {

        if (listQueryLoggingConfigsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<ListQueryLoggingConfigsRequest> request = new DefaultRequest<ListQueryLoggingConfigsRequest>(
                listQueryLoggingConfigsRequest, "Route53Client");

        request.setHttpMethod(HttpMethodName.GET);

        String uriResourcePath = "/2013-04-01/queryloggingconfig";

        request.setResourcePath(uriResourcePath);

        if (listQueryLoggingConfigsRequest.hostedZoneId() != null) {
            request.addParameter("hostedzoneid", StringUtils.fromString(listQueryLoggingConfigsRequest.hostedZoneId()));
        }

        if (listQueryLoggingConfigsRequest.nextToken() != null) {
            request.addParameter("nexttoken", StringUtils.fromString(listQueryLoggingConfigsRequest.nextToken()));
        }

        if (listQueryLoggingConfigsRequest.maxResults() != null) {
            request.addParameter("maxresults", StringUtils.fromString(listQueryLoggingConfigsRequest.maxResults()));
        }

        return request;
    }

}