/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.route53.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;

import software.amazon.awssdk.core.util.StringUtils;

/**
 * TestDNSAnswerRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class TestDNSAnswerRequestMarshaller implements Marshaller<Request<TestDNSAnswerRequest>, TestDNSAnswerRequest> {

    public Request<TestDNSAnswerRequest> marshall(TestDNSAnswerRequest testDNSAnswerRequest) {

        if (testDNSAnswerRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<TestDNSAnswerRequest> request = new DefaultRequest<TestDNSAnswerRequest>(testDNSAnswerRequest, "Route53Client");

        request.setHttpMethod(HttpMethodName.GET);

        String uriResourcePath = "/2013-04-01/testdnsanswer";

        request.setResourcePath(uriResourcePath);

        if (testDNSAnswerRequest.hostedZoneId() != null) {
            request.addParameter("hostedzoneid", StringUtils.fromString(testDNSAnswerRequest.hostedZoneId()));
        }

        if (testDNSAnswerRequest.recordName() != null) {
            request.addParameter("recordname", StringUtils.fromString(testDNSAnswerRequest.recordName()));
        }

        if (testDNSAnswerRequest.recordTypeString() != null) {
            request.addParameter("recordtype", StringUtils.fromString(testDNSAnswerRequest.recordTypeString()));
        }

        if (testDNSAnswerRequest.resolverIP() != null) {
            request.addParameter("resolverip", StringUtils.fromString(testDNSAnswerRequest.resolverIP()));
        }

        if (testDNSAnswerRequest.edns0ClientSubnetIP() != null) {
            request.addParameter("edns0clientsubnetip", StringUtils.fromString(testDNSAnswerRequest.edns0ClientSubnetIP()));
        }

        if (testDNSAnswerRequest.edns0ClientSubnetMask() != null) {
            request.addParameter("edns0clientsubnetmask", StringUtils.fromString(testDNSAnswerRequest.edns0ClientSubnetMask()));
        }

        return request;
    }

}