/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53domains.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.route53domains.transform.BillingRecordMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information for one billing record.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class BillingRecord implements StructuredPojo, ToCopyableBuilder<BillingRecord.Builder, BillingRecord> {
    private final String domainName;

    private final String operation;

    private final String invoiceId;

    private final Instant billDate;

    private final Double price;

    private BillingRecord(BuilderImpl builder) {
        this.domainName = builder.domainName;
        this.operation = builder.operation;
        this.invoiceId = builder.invoiceId;
        this.billDate = builder.billDate;
        this.price = builder.price;
    }

    /**
     * <p>
     * The name of the domain that the billing record applies to. If the domain name contains characters other than a-z,
     * 0-9, and - (hyphen), such as an internationalized domain name, then this value is in Punycode. For more
     * information, see <a href="http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DomainNameFormat.html">DNS
     * Domain Name Format</a> in the <i>Amazon Route 53 Developer Guidezzz</i>.
     * </p>
     * 
     * @return The name of the domain that the billing record applies to. If the domain name contains characters other
     *         than a-z, 0-9, and - (hyphen), such as an internationalized domain name, then this value is in Punycode.
     *         For more information, see <a
     *         href="http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DomainNameFormat.html">DNS Domain Name
     *         Format</a> in the <i>Amazon Route 53 Developer Guidezzz</i>.
     */
    public String domainName() {
        return domainName;
    }

    /**
     * <p>
     * The operation that you were charged for.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operation} will
     * return {@link OperationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #operationString}.
     * </p>
     * 
     * @return The operation that you were charged for.
     * @see OperationType
     */
    public OperationType operation() {
        return OperationType.fromValue(operation);
    }

    /**
     * <p>
     * The operation that you were charged for.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operation} will
     * return {@link OperationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #operationString}.
     * </p>
     * 
     * @return The operation that you were charged for.
     * @see OperationType
     */
    public String operationString() {
        return operation;
    }

    /**
     * <p>
     * The ID of the invoice that is associated with the billing record.
     * </p>
     * 
     * @return The ID of the invoice that is associated with the billing record.
     */
    public String invoiceId() {
        return invoiceId;
    }

    /**
     * <p>
     * The date that the operation was billed, in Unix format.
     * </p>
     * 
     * @return The date that the operation was billed, in Unix format.
     */
    public Instant billDate() {
        return billDate;
    }

    /**
     * <p>
     * The price that you were charged for the operation, in US dollars.
     * </p>
     * <p>
     * Example value: 12.0
     * </p>
     * 
     * @return The price that you were charged for the operation, in US dollars.</p>
     *         <p>
     *         Example value: 12.0
     */
    public Double price() {
        return price;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(operationString());
        hashCode = 31 * hashCode + Objects.hashCode(invoiceId());
        hashCode = 31 * hashCode + Objects.hashCode(billDate());
        hashCode = 31 * hashCode + Objects.hashCode(price());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BillingRecord)) {
            return false;
        }
        BillingRecord other = (BillingRecord) obj;
        return Objects.equals(domainName(), other.domainName()) && Objects.equals(operationString(), other.operationString())
                && Objects.equals(invoiceId(), other.invoiceId()) && Objects.equals(billDate(), other.billDate())
                && Objects.equals(price(), other.price());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (domainName() != null) {
            sb.append("DomainName: ").append(domainName()).append(",");
        }
        if (operationString() != null) {
            sb.append("Operation: ").append(operationString()).append(",");
        }
        if (invoiceId() != null) {
            sb.append("InvoiceId: ").append(invoiceId()).append(",");
        }
        if (billDate() != null) {
            sb.append("BillDate: ").append(billDate()).append(",");
        }
        if (price() != null) {
            sb.append("Price: ").append(price()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainName":
            return Optional.of(clazz.cast(domainName()));
        case "Operation":
            return Optional.of(clazz.cast(operationString()));
        case "InvoiceId":
            return Optional.of(clazz.cast(invoiceId()));
        case "BillDate":
            return Optional.of(clazz.cast(billDate()));
        case "Price":
            return Optional.of(clazz.cast(price()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BillingRecordMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, BillingRecord> {
        /**
         * <p>
         * The name of the domain that the billing record applies to. If the domain name contains characters other than
         * a-z, 0-9, and - (hyphen), such as an internationalized domain name, then this value is in Punycode. For more
         * information, see <a href="http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DomainNameFormat.html">DNS
         * Domain Name Format</a> in the <i>Amazon Route 53 Developer Guidezzz</i>.
         * </p>
         * 
         * @param domainName
         *        The name of the domain that the billing record applies to. If the domain name contains characters
         *        other than a-z, 0-9, and - (hyphen), such as an internationalized domain name, then this value is in
         *        Punycode. For more information, see <a
         *        href="http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DomainNameFormat.html">DNS Domain Name
         *        Format</a> in the <i>Amazon Route 53 Developer Guidezzz</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * The operation that you were charged for.
         * </p>
         * 
         * @param operation
         *        The operation that you were charged for.
         * @see OperationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperationType
         */
        Builder operation(String operation);

        /**
         * <p>
         * The operation that you were charged for.
         * </p>
         * 
         * @param operation
         *        The operation that you were charged for.
         * @see OperationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperationType
         */
        Builder operation(OperationType operation);

        /**
         * <p>
         * The ID of the invoice that is associated with the billing record.
         * </p>
         * 
         * @param invoiceId
         *        The ID of the invoice that is associated with the billing record.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invoiceId(String invoiceId);

        /**
         * <p>
         * The date that the operation was billed, in Unix format.
         * </p>
         * 
         * @param billDate
         *        The date that the operation was billed, in Unix format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder billDate(Instant billDate);

        /**
         * <p>
         * The price that you were charged for the operation, in US dollars.
         * </p>
         * <p>
         * Example value: 12.0
         * </p>
         * 
         * @param price
         *        The price that you were charged for the operation, in US dollars.</p>
         *        <p>
         *        Example value: 12.0
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder price(Double price);
    }

    static final class BuilderImpl implements Builder {
        private String domainName;

        private String operation;

        private String invoiceId;

        private Instant billDate;

        private Double price;

        private BuilderImpl() {
        }

        private BuilderImpl(BillingRecord model) {
            domainName(model.domainName);
            operation(model.operation);
            invoiceId(model.invoiceId);
            billDate(model.billDate);
            price(model.price);
        }

        public final String getDomainName() {
            return domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final String getOperation() {
            return operation;
        }

        @Override
        public final Builder operation(String operation) {
            this.operation = operation;
            return this;
        }

        @Override
        public final Builder operation(OperationType operation) {
            this.operation(operation.toString());
            return this;
        }

        public final void setOperation(String operation) {
            this.operation = operation;
        }

        public final String getInvoiceId() {
            return invoiceId;
        }

        @Override
        public final Builder invoiceId(String invoiceId) {
            this.invoiceId = invoiceId;
            return this;
        }

        public final void setInvoiceId(String invoiceId) {
            this.invoiceId = invoiceId;
        }

        public final Instant getBillDate() {
            return billDate;
        }

        @Override
        public final Builder billDate(Instant billDate) {
            this.billDate = billDate;
            return this;
        }

        public final void setBillDate(Instant billDate) {
            this.billDate = billDate;
        }

        public final Double getPrice() {
            return price;
        }

        @Override
        public final Builder price(Double price) {
            this.price = price;
            return this;
        }

        public final void setPrice(Double price) {
            this.price = price;
        }

        @Override
        public BillingRecord build() {
            return new BillingRecord(this);
        }
    }
}
