/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53domains.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The CheckDomainTransferability request contains the following elements.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CheckDomainTransferabilityRequest extends Route53DomainsRequest implements
        ToCopyableBuilder<CheckDomainTransferabilityRequest.Builder, CheckDomainTransferabilityRequest> {
    private final String domainName;

    private final String authCode;

    private CheckDomainTransferabilityRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.authCode = builder.authCode;
    }

    /**
     * <p>
     * The name of the domain that you want to transfer to Amazon Route 53.
     * </p>
     * <p>
     * Constraints: The domain name can contain only the letters a through z, the numbers 0 through 9, and hyphen (-).
     * Internationalized Domain Names are not supported.
     * </p>
     * 
     * @return The name of the domain that you want to transfer to Amazon Route 53.</p>
     *         <p>
     *         Constraints: The domain name can contain only the letters a through z, the numbers 0 through 9, and
     *         hyphen (-). Internationalized Domain Names are not supported.
     */
    public String domainName() {
        return domainName;
    }

    /**
     * <p>
     * If the registrar for the top-level domain (TLD) requires an authorization code to transfer the domain, the code
     * that you got from the current registrar for the domain.
     * </p>
     * 
     * @return If the registrar for the top-level domain (TLD) requires an authorization code to transfer the domain,
     *         the code that you got from the current registrar for the domain.
     */
    public String authCode() {
        return authCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(authCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CheckDomainTransferabilityRequest)) {
            return false;
        }
        CheckDomainTransferabilityRequest other = (CheckDomainTransferabilityRequest) obj;
        return Objects.equals(domainName(), other.domainName()) && Objects.equals(authCode(), other.authCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (domainName() != null) {
            sb.append("DomainName: ").append(domainName()).append(",");
        }
        if (authCode() != null) {
            sb.append("AuthCode: ").append(authCode()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainName":
            return Optional.of(clazz.cast(domainName()));
        case "AuthCode":
            return Optional.of(clazz.cast(authCode()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends Route53DomainsRequest.Builder, CopyableBuilder<Builder, CheckDomainTransferabilityRequest> {
        /**
         * <p>
         * The name of the domain that you want to transfer to Amazon Route 53.
         * </p>
         * <p>
         * Constraints: The domain name can contain only the letters a through z, the numbers 0 through 9, and hyphen
         * (-). Internationalized Domain Names are not supported.
         * </p>
         * 
         * @param domainName
         *        The name of the domain that you want to transfer to Amazon Route 53.</p>
         *        <p>
         *        Constraints: The domain name can contain only the letters a through z, the numbers 0 through 9, and
         *        hyphen (-). Internationalized Domain Names are not supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * If the registrar for the top-level domain (TLD) requires an authorization code to transfer the domain, the
         * code that you got from the current registrar for the domain.
         * </p>
         * 
         * @param authCode
         *        If the registrar for the top-level domain (TLD) requires an authorization code to transfer the domain,
         *        the code that you got from the current registrar for the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authCode(String authCode);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends Route53DomainsRequest.BuilderImpl implements Builder {
        private String domainName;

        private String authCode;

        private BuilderImpl() {
        }

        private BuilderImpl(CheckDomainTransferabilityRequest model) {
            domainName(model.domainName);
            authCode(model.authCode);
        }

        public final String getDomainName() {
            return domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final String getAuthCode() {
            return authCode;
        }

        @Override
        public final Builder authCode(String authCode) {
            this.authCode = authCode;
            return this;
        }

        public final void setAuthCode(String authCode) {
            this.authCode = authCode;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CheckDomainTransferabilityRequest build() {
            return new CheckDomainTransferabilityRequest(this);
        }
    }
}
