/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53domains.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetDomainSuggestionsResponse extends Route53DomainsResponse implements
        ToCopyableBuilder<GetDomainSuggestionsResponse.Builder, GetDomainSuggestionsResponse> {
    private final List<DomainSuggestion> suggestionsList;

    private GetDomainSuggestionsResponse(BuilderImpl builder) {
        super(builder);
        this.suggestionsList = builder.suggestionsList;
    }

    /**
     * <p>
     * A list of possible domain names. If you specified <code>true</code> for <code>OnlyAvailable</code> in the
     * request, the list contains only domains that are available for registration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of possible domain names. If you specified <code>true</code> for <code>OnlyAvailable</code> in the
     *         request, the list contains only domains that are available for registration.
     */
    public List<DomainSuggestion> suggestionsList() {
        return suggestionsList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(suggestionsList());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDomainSuggestionsResponse)) {
            return false;
        }
        GetDomainSuggestionsResponse other = (GetDomainSuggestionsResponse) obj;
        return Objects.equals(suggestionsList(), other.suggestionsList());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (suggestionsList() != null) {
            sb.append("SuggestionsList: ").append(suggestionsList()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SuggestionsList":
            return Optional.of(clazz.cast(suggestionsList()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends Route53DomainsResponse.Builder, CopyableBuilder<Builder, GetDomainSuggestionsResponse> {
        /**
         * <p>
         * A list of possible domain names. If you specified <code>true</code> for <code>OnlyAvailable</code> in the
         * request, the list contains only domains that are available for registration.
         * </p>
         * 
         * @param suggestionsList
         *        A list of possible domain names. If you specified <code>true</code> for <code>OnlyAvailable</code> in
         *        the request, the list contains only domains that are available for registration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suggestionsList(Collection<DomainSuggestion> suggestionsList);

        /**
         * <p>
         * A list of possible domain names. If you specified <code>true</code> for <code>OnlyAvailable</code> in the
         * request, the list contains only domains that are available for registration.
         * </p>
         * 
         * @param suggestionsList
         *        A list of possible domain names. If you specified <code>true</code> for <code>OnlyAvailable</code> in
         *        the request, the list contains only domains that are available for registration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suggestionsList(DomainSuggestion... suggestionsList);
    }

    static final class BuilderImpl extends Route53DomainsResponse.BuilderImpl implements Builder {
        private List<DomainSuggestion> suggestionsList;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDomainSuggestionsResponse model) {
            suggestionsList(model.suggestionsList);
        }

        public final Collection<DomainSuggestion.Builder> getSuggestionsList() {
            return suggestionsList != null ? suggestionsList.stream().map(DomainSuggestion::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder suggestionsList(Collection<DomainSuggestion> suggestionsList) {
            this.suggestionsList = DomainSuggestionsListCopier.copy(suggestionsList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder suggestionsList(DomainSuggestion... suggestionsList) {
            suggestionsList(Arrays.asList(suggestionsList));
            return this;
        }

        public final void setSuggestionsList(Collection<DomainSuggestion.BuilderImpl> suggestionsList) {
            this.suggestionsList = DomainSuggestionsListCopier.copyFromBuilder(suggestionsList);
        }

        @Override
        public GetDomainSuggestionsResponse build() {
            return new GetDomainSuggestionsResponse(this);
        }
    }
}
