/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53domains.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.route53domains.model.*;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * GetDomainDetailResponse JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class GetDomainDetailResponseUnmarshaller implements Unmarshaller<GetDomainDetailResponse, JsonUnmarshallerContext> {

    public GetDomainDetailResponse unmarshall(JsonUnmarshallerContext context) throws Exception {
        GetDomainDetailResponse.Builder getDomainDetailResponseBuilder = GetDomainDetailResponse.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return getDomainDetailResponseBuilder.build();
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("DomainName", targetDepth)) {
                    context.nextToken();
                    getDomainDetailResponseBuilder.domainName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Nameservers", targetDepth)) {
                    context.nextToken();
                    getDomainDetailResponseBuilder.nameservers(new ListUnmarshaller<Nameserver>(NameserverUnmarshaller
                            .getInstance()).unmarshall(context));
                }
                if (context.testExpression("AutoRenew", targetDepth)) {
                    context.nextToken();
                    getDomainDetailResponseBuilder.autoRenew(context.getUnmarshaller(Boolean.class).unmarshall(context));
                }
                if (context.testExpression("AdminContact", targetDepth)) {
                    context.nextToken();
                    getDomainDetailResponseBuilder.adminContact(ContactDetailUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("RegistrantContact", targetDepth)) {
                    context.nextToken();
                    getDomainDetailResponseBuilder.registrantContact(ContactDetailUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("TechContact", targetDepth)) {
                    context.nextToken();
                    getDomainDetailResponseBuilder.techContact(ContactDetailUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("AdminPrivacy", targetDepth)) {
                    context.nextToken();
                    getDomainDetailResponseBuilder.adminPrivacy(context.getUnmarshaller(Boolean.class).unmarshall(context));
                }
                if (context.testExpression("RegistrantPrivacy", targetDepth)) {
                    context.nextToken();
                    getDomainDetailResponseBuilder.registrantPrivacy(context.getUnmarshaller(Boolean.class).unmarshall(context));
                }
                if (context.testExpression("TechPrivacy", targetDepth)) {
                    context.nextToken();
                    getDomainDetailResponseBuilder.techPrivacy(context.getUnmarshaller(Boolean.class).unmarshall(context));
                }
                if (context.testExpression("RegistrarName", targetDepth)) {
                    context.nextToken();
                    getDomainDetailResponseBuilder.registrarName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("WhoIsServer", targetDepth)) {
                    context.nextToken();
                    getDomainDetailResponseBuilder.whoIsServer(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("RegistrarUrl", targetDepth)) {
                    context.nextToken();
                    getDomainDetailResponseBuilder.registrarUrl(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("AbuseContactEmail", targetDepth)) {
                    context.nextToken();
                    getDomainDetailResponseBuilder.abuseContactEmail(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("AbuseContactPhone", targetDepth)) {
                    context.nextToken();
                    getDomainDetailResponseBuilder.abuseContactPhone(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("RegistryDomainId", targetDepth)) {
                    context.nextToken();
                    getDomainDetailResponseBuilder.registryDomainId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("CreationDate", targetDepth)) {
                    context.nextToken();
                    getDomainDetailResponseBuilder.creationDate(context.getUnmarshaller(java.time.Instant.class).unmarshall(
                            context));
                }
                if (context.testExpression("UpdatedDate", targetDepth)) {
                    context.nextToken();
                    getDomainDetailResponseBuilder.updatedDate(context.getUnmarshaller(java.time.Instant.class).unmarshall(
                            context));
                }
                if (context.testExpression("ExpirationDate", targetDepth)) {
                    context.nextToken();
                    getDomainDetailResponseBuilder.expirationDate(context.getUnmarshaller(java.time.Instant.class).unmarshall(
                            context));
                }
                if (context.testExpression("Reseller", targetDepth)) {
                    context.nextToken();
                    getDomainDetailResponseBuilder.reseller(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("DnsSec", targetDepth)) {
                    context.nextToken();
                    getDomainDetailResponseBuilder.dnsSec(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("StatusList", targetDepth)) {
                    context.nextToken();
                    getDomainDetailResponseBuilder.statusList(new ListUnmarshaller<String>(context.getUnmarshaller(String.class))
                            .unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return getDomainDetailResponseBuilder.build();
    }

    private static final GetDomainDetailResponseUnmarshaller INSTANCE = new GetDomainDetailResponseUnmarshaller();

    public static GetDomainDetailResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
