/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.route53.model.CloudWatchRegion;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AlarmIdentifier
implements ToCopyableBuilder<Builder, AlarmIdentifier> {
    private final String region;
    private final String name;

    private AlarmIdentifier(BuilderImpl builder) {
        this.region = builder.region;
        this.name = builder.name;
    }

    public CloudWatchRegion region() {
        return CloudWatchRegion.fromValue(this.region);
    }

    public String regionString() {
        return this.region;
    }

    public String name() {
        return this.name;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.regionString());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AlarmIdentifier)) {
            return false;
        }
        AlarmIdentifier other = (AlarmIdentifier)obj;
        return Objects.equals(this.regionString(), other.regionString()) && Objects.equals(this.name(), other.name());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.regionString() != null) {
            sb.append("Region: ").append(this.regionString()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Region": {
                return Optional.of(clazz.cast(this.regionString()));
            }
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String region;
        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(AlarmIdentifier model) {
            this.region(model.region);
            this.name(model.name);
        }

        public final String getRegion() {
            return this.region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        @Override
        public final Builder region(CloudWatchRegion region) {
            this.region(region.toString());
            return this;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public AlarmIdentifier build() {
            return new AlarmIdentifier(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AlarmIdentifier> {
        public Builder region(String var1);

        public Builder region(CloudWatchRegion var1);

        public Builder name(String var1);
    }
}

