/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.route53.model.Route53Request;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateReusableDelegationSetRequest
extends Route53Request
implements ToCopyableBuilder<Builder, CreateReusableDelegationSetRequest> {
    private final String callerReference;
    private final String hostedZoneId;

    private CreateReusableDelegationSetRequest(BuilderImpl builder) {
        super(builder);
        this.callerReference = builder.callerReference;
        this.hostedZoneId = builder.hostedZoneId;
    }

    public String callerReference() {
        return this.callerReference;
    }

    public String hostedZoneId() {
        return this.hostedZoneId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.callerReference());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostedZoneId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateReusableDelegationSetRequest)) {
            return false;
        }
        CreateReusableDelegationSetRequest other = (CreateReusableDelegationSetRequest)((Object)obj);
        return Objects.equals(this.callerReference(), other.callerReference()) && Objects.equals(this.hostedZoneId(), other.hostedZoneId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.callerReference() != null) {
            sb.append("CallerReference: ").append(this.callerReference()).append(",");
        }
        if (this.hostedZoneId() != null) {
            sb.append("HostedZoneId: ").append(this.hostedZoneId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CallerReference": {
                return Optional.of(clazz.cast(this.callerReference()));
            }
            case "HostedZoneId": {
                return Optional.of(clazz.cast(this.hostedZoneId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends Route53Request.BuilderImpl
    implements Builder {
        private String callerReference;
        private String hostedZoneId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateReusableDelegationSetRequest model) {
            this.callerReference(model.callerReference);
            this.hostedZoneId(model.hostedZoneId);
        }

        public final String getCallerReference() {
            return this.callerReference;
        }

        @Override
        public final Builder callerReference(String callerReference) {
            this.callerReference = callerReference;
            return this;
        }

        public final void setCallerReference(String callerReference) {
            this.callerReference = callerReference;
        }

        public final String getHostedZoneId() {
            return this.hostedZoneId;
        }

        @Override
        public final Builder hostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
            return this;
        }

        public final void setHostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateReusableDelegationSetRequest build() {
            return new CreateReusableDelegationSetRequest(this);
        }
    }

    public static interface Builder
    extends Route53Request.Builder,
    CopyableBuilder<Builder, CreateReusableDelegationSetRequest> {
        public Builder callerReference(String var1);

        public Builder hostedZoneId(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

