/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.route53.model.ResourceTagSet;
import software.amazon.awssdk.services.route53.model.ResourceTagSetListCopier;
import software.amazon.awssdk.services.route53.model.Route53Response;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListTagsForResourcesResponse
extends Route53Response
implements ToCopyableBuilder<Builder, ListTagsForResourcesResponse> {
    private final List<ResourceTagSet> resourceTagSets;

    private ListTagsForResourcesResponse(BuilderImpl builder) {
        super(builder);
        this.resourceTagSets = builder.resourceTagSets;
    }

    public List<ResourceTagSet> resourceTagSets() {
        return this.resourceTagSets;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTagSets());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTagsForResourcesResponse)) {
            return false;
        }
        ListTagsForResourcesResponse other = (ListTagsForResourcesResponse)((Object)obj);
        return Objects.equals(this.resourceTagSets(), other.resourceTagSets());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.resourceTagSets() != null) {
            sb.append("ResourceTagSets: ").append(this.resourceTagSets()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceTagSets": {
                return Optional.of(clazz.cast(this.resourceTagSets()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends Route53Response.BuilderImpl
    implements Builder {
        private List<ResourceTagSet> resourceTagSets;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTagsForResourcesResponse model) {
            this.resourceTagSets(model.resourceTagSets);
        }

        public final Collection<ResourceTagSet.Builder> getResourceTagSets() {
            return this.resourceTagSets != null ? (Collection)this.resourceTagSets.stream().map(ResourceTagSet::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder resourceTagSets(Collection<ResourceTagSet> resourceTagSets) {
            this.resourceTagSets = ResourceTagSetListCopier.copy(resourceTagSets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTagSets(ResourceTagSet ... resourceTagSets) {
            this.resourceTagSets(Arrays.asList(resourceTagSets));
            return this;
        }

        public final void setResourceTagSets(Collection<ResourceTagSet.BuilderImpl> resourceTagSets) {
            this.resourceTagSets = ResourceTagSetListCopier.copyFromBuilder(resourceTagSets);
        }

        @Override
        public ListTagsForResourcesResponse build() {
            return new ListTagsForResourcesResponse(this);
        }
    }

    public static interface Builder
    extends Route53Response.Builder,
    CopyableBuilder<Builder, ListTagsForResourcesResponse> {
        public Builder resourceTagSets(Collection<ResourceTagSet> var1);

        public Builder resourceTagSets(ResourceTagSet ... var1);
    }
}

