/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.route53.model.AccountLimit;

public class AccountLimitUnmarshaller
implements Unmarshaller<AccountLimit, StaxUnmarshallerContext> {
    private static final AccountLimitUnmarshaller INSTANCE = new AccountLimitUnmarshaller();

    public AccountLimit unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        AccountLimit.Builder accountLimit = AccountLimit.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Type", targetDepth)) {
                    accountLimit.type(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Value", targetDepth)) continue;
                accountLimit.value(SimpleTypeStaxUnmarshallers.LongUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (AccountLimit)accountLimit.build();
    }

    public static AccountLimitUnmarshaller getInstance() {
        return INSTANCE;
    }
}

