/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.route53.model.StatusReport;

public class StatusReportUnmarshaller
implements Unmarshaller<StatusReport, StaxUnmarshallerContext> {
    private static final StatusReportUnmarshaller INSTANCE = new StatusReportUnmarshaller();

    public StatusReport unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        StatusReport.Builder statusReport = StatusReport.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Status", targetDepth)) {
                    statusReport.status(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("CheckedTime", targetDepth)) continue;
                statusReport.checkedTime(SimpleTypeStaxUnmarshallers.InstantUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (StatusReport)statusReport.build();
    }

    public static StatusReportUnmarshaller getInstance() {
        return INSTANCE;
    }
}

