/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53domains.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.route53domains.model.Nameserver;
import software.amazon.awssdk.services.route53domains.model.NameserverListCopier;
import software.amazon.awssdk.services.route53domains.model.Route53DomainsRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateDomainNameserversRequest
extends Route53DomainsRequest
implements ToCopyableBuilder<Builder, UpdateDomainNameserversRequest> {
    private final String domainName;
    private final String fiAuthKey;
    private final List<Nameserver> nameservers;

    private UpdateDomainNameserversRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.fiAuthKey = builder.fiAuthKey;
        this.nameservers = builder.nameservers;
    }

    public String domainName() {
        return this.domainName;
    }

    public String fiAuthKey() {
        return this.fiAuthKey;
    }

    public List<Nameserver> nameservers() {
        return this.nameservers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.fiAuthKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.nameservers());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDomainNameserversRequest)) {
            return false;
        }
        UpdateDomainNameserversRequest other = (UpdateDomainNameserversRequest)((Object)obj);
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.fiAuthKey(), other.fiAuthKey()) && Objects.equals(this.nameservers(), other.nameservers());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.domainName() != null) {
            sb.append("DomainName: ").append(this.domainName()).append(",");
        }
        if (this.fiAuthKey() != null) {
            sb.append("FIAuthKey: ").append(this.fiAuthKey()).append(",");
        }
        if (this.nameservers() != null) {
            sb.append("Nameservers: ").append(this.nameservers()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.of(clazz.cast(this.domainName()));
            }
            case "FIAuthKey": {
                return Optional.of(clazz.cast(this.fiAuthKey()));
            }
            case "Nameservers": {
                return Optional.of(clazz.cast(this.nameservers()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends Route53DomainsRequest.BuilderImpl
    implements Builder {
        private String domainName;
        private String fiAuthKey;
        private List<Nameserver> nameservers;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDomainNameserversRequest model) {
            this.domainName(model.domainName);
            this.fiAuthKey(model.fiAuthKey);
            this.nameservers(model.nameservers);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final String getFIAuthKey() {
            return this.fiAuthKey;
        }

        @Override
        public final Builder fiAuthKey(String fiAuthKey) {
            this.fiAuthKey = fiAuthKey;
            return this;
        }

        public final void setFIAuthKey(String fiAuthKey) {
            this.fiAuthKey = fiAuthKey;
        }

        public final Collection<Nameserver.Builder> getNameservers() {
            return this.nameservers != null ? (Collection)this.nameservers.stream().map(Nameserver::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder nameservers(Collection<Nameserver> nameservers) {
            this.nameservers = NameserverListCopier.copy(nameservers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nameservers(Nameserver ... nameservers) {
            this.nameservers(Arrays.asList(nameservers));
            return this;
        }

        public final void setNameservers(Collection<Nameserver.BuilderImpl> nameservers) {
            this.nameservers = NameserverListCopier.copyFromBuilder(nameservers);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public UpdateDomainNameserversRequest build() {
            return new UpdateDomainNameserversRequest(this);
        }
    }

    public static interface Builder
    extends Route53DomainsRequest.Builder,
    CopyableBuilder<Builder, UpdateDomainNameserversRequest> {
        public Builder domainName(String var1);

        public Builder fiAuthKey(String var1);

        public Builder nameservers(Collection<Nameserver> var1);

        public Builder nameservers(Nameserver ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

