/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateReusableDelegationSetRequest extends Route53Request implements
        ToCopyableBuilder<CreateReusableDelegationSetRequest.Builder, CreateReusableDelegationSetRequest> {
    private final String callerReference;

    private final String hostedZoneId;

    private CreateReusableDelegationSetRequest(BuilderImpl builder) {
        super(builder);
        this.callerReference = builder.callerReference;
        this.hostedZoneId = builder.hostedZoneId;
    }

    /**
     * <p>
     * A unique string that identifies the request, and that allows you to retry failed
     * <code>CreateReusableDelegationSet</code> requests without the risk of executing the operation twice. You must use
     * a unique <code>CallerReference</code> string every time you submit a <code>CreateReusableDelegationSet</code>
     * request. <code>CallerReference</code> can be any unique string, for example a date/time stamp.
     * </p>
     * 
     * @return A unique string that identifies the request, and that allows you to retry failed
     *         <code>CreateReusableDelegationSet</code> requests without the risk of executing the operation twice. You
     *         must use a unique <code>CallerReference</code> string every time you submit a
     *         <code>CreateReusableDelegationSet</code> request. <code>CallerReference</code> can be any unique string,
     *         for example a date/time stamp.
     */
    public String callerReference() {
        return callerReference;
    }

    /**
     * <p>
     * If you want to mark the delegation set for an existing hosted zone as reusable, the ID for that hosted zone.
     * </p>
     * 
     * @return If you want to mark the delegation set for an existing hosted zone as reusable, the ID for that hosted
     *         zone.
     */
    public String hostedZoneId() {
        return hostedZoneId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(callerReference());
        hashCode = 31 * hashCode + Objects.hashCode(hostedZoneId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateReusableDelegationSetRequest)) {
            return false;
        }
        CreateReusableDelegationSetRequest other = (CreateReusableDelegationSetRequest) obj;
        return Objects.equals(callerReference(), other.callerReference()) && Objects.equals(hostedZoneId(), other.hostedZoneId());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateReusableDelegationSetRequest").add("CallerReference", callerReference())
                .add("HostedZoneId", hostedZoneId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CallerReference":
            return Optional.of(clazz.cast(callerReference()));
        case "HostedZoneId":
            return Optional.of(clazz.cast(hostedZoneId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends Route53Request.Builder, CopyableBuilder<Builder, CreateReusableDelegationSetRequest> {
        /**
         * <p>
         * A unique string that identifies the request, and that allows you to retry failed
         * <code>CreateReusableDelegationSet</code> requests without the risk of executing the operation twice. You must
         * use a unique <code>CallerReference</code> string every time you submit a
         * <code>CreateReusableDelegationSet</code> request. <code>CallerReference</code> can be any unique string, for
         * example a date/time stamp.
         * </p>
         * 
         * @param callerReference
         *        A unique string that identifies the request, and that allows you to retry failed
         *        <code>CreateReusableDelegationSet</code> requests without the risk of executing the operation twice.
         *        You must use a unique <code>CallerReference</code> string every time you submit a
         *        <code>CreateReusableDelegationSet</code> request. <code>CallerReference</code> can be any unique
         *        string, for example a date/time stamp.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder callerReference(String callerReference);

        /**
         * <p>
         * If you want to mark the delegation set for an existing hosted zone as reusable, the ID for that hosted zone.
         * </p>
         * 
         * @param hostedZoneId
         *        If you want to mark the delegation set for an existing hosted zone as reusable, the ID for that hosted
         *        zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostedZoneId(String hostedZoneId);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends Route53Request.BuilderImpl implements Builder {
        private String callerReference;

        private String hostedZoneId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateReusableDelegationSetRequest model) {
            callerReference(model.callerReference);
            hostedZoneId(model.hostedZoneId);
        }

        public final String getCallerReference() {
            return callerReference;
        }

        @Override
        public final Builder callerReference(String callerReference) {
            this.callerReference = callerReference;
            return this;
        }

        public final void setCallerReference(String callerReference) {
            this.callerReference = callerReference;
        }

        public final String getHostedZoneId() {
            return hostedZoneId;
        }

        @Override
        public final Builder hostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
            return this;
        }

        public final void setHostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateReusableDelegationSetRequest build() {
            return new CreateReusableDelegationSetRequest(this);
        }
    }
}
