/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains the response information for the <code>CreateTrafficPolicyInstance</code> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateTrafficPolicyInstanceResponse extends Route53Response implements
        ToCopyableBuilder<CreateTrafficPolicyInstanceResponse.Builder, CreateTrafficPolicyInstanceResponse> {
    private final TrafficPolicyInstance trafficPolicyInstance;

    private final String location;

    private CreateTrafficPolicyInstanceResponse(BuilderImpl builder) {
        super(builder);
        this.trafficPolicyInstance = builder.trafficPolicyInstance;
        this.location = builder.location;
    }

    /**
     * <p>
     * A complex type that contains settings for the new traffic policy instance.
     * </p>
     * 
     * @return A complex type that contains settings for the new traffic policy instance.
     */
    public TrafficPolicyInstance trafficPolicyInstance() {
        return trafficPolicyInstance;
    }

    /**
     * <p>
     * A unique URL that represents a new traffic policy instance.
     * </p>
     * 
     * @return A unique URL that represents a new traffic policy instance.
     */
    public String location() {
        return location;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(trafficPolicyInstance());
        hashCode = 31 * hashCode + Objects.hashCode(location());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTrafficPolicyInstanceResponse)) {
            return false;
        }
        CreateTrafficPolicyInstanceResponse other = (CreateTrafficPolicyInstanceResponse) obj;
        return Objects.equals(trafficPolicyInstance(), other.trafficPolicyInstance())
                && Objects.equals(location(), other.location());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateTrafficPolicyInstanceResponse").add("TrafficPolicyInstance", trafficPolicyInstance())
                .add("Location", location()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TrafficPolicyInstance":
            return Optional.of(clazz.cast(trafficPolicyInstance()));
        case "Location":
            return Optional.of(clazz.cast(location()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends Route53Response.Builder, CopyableBuilder<Builder, CreateTrafficPolicyInstanceResponse> {
        /**
         * <p>
         * A complex type that contains settings for the new traffic policy instance.
         * </p>
         * 
         * @param trafficPolicyInstance
         *        A complex type that contains settings for the new traffic policy instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trafficPolicyInstance(TrafficPolicyInstance trafficPolicyInstance);

        /**
         * <p>
         * A complex type that contains settings for the new traffic policy instance.
         * </p>
         * This is a convenience that creates an instance of the {@link TrafficPolicyInstance.Builder} avoiding the need
         * to create one manually via {@link TrafficPolicyInstance#builder()}.
         *
         * When the {@link Consumer} completes, {@link TrafficPolicyInstance.Builder#build()} is called immediately and
         * its result is passed to {@link #trafficPolicyInstance(TrafficPolicyInstance)}.
         * 
         * @param trafficPolicyInstance
         *        a consumer that will call methods on {@link TrafficPolicyInstance.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trafficPolicyInstance(TrafficPolicyInstance)
         */
        default Builder trafficPolicyInstance(Consumer<TrafficPolicyInstance.Builder> trafficPolicyInstance) {
            return trafficPolicyInstance(TrafficPolicyInstance.builder().apply(trafficPolicyInstance).build());
        }

        /**
         * <p>
         * A unique URL that represents a new traffic policy instance.
         * </p>
         * 
         * @param location
         *        A unique URL that represents a new traffic policy instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(String location);
    }

    static final class BuilderImpl extends Route53Response.BuilderImpl implements Builder {
        private TrafficPolicyInstance trafficPolicyInstance;

        private String location;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTrafficPolicyInstanceResponse model) {
            trafficPolicyInstance(model.trafficPolicyInstance);
            location(model.location);
        }

        public final TrafficPolicyInstance.Builder getTrafficPolicyInstance() {
            return trafficPolicyInstance != null ? trafficPolicyInstance.toBuilder() : null;
        }

        @Override
        public final Builder trafficPolicyInstance(TrafficPolicyInstance trafficPolicyInstance) {
            this.trafficPolicyInstance = trafficPolicyInstance;
            return this;
        }

        public final void setTrafficPolicyInstance(TrafficPolicyInstance.BuilderImpl trafficPolicyInstance) {
            this.trafficPolicyInstance = trafficPolicyInstance != null ? trafficPolicyInstance.build() : null;
        }

        public final String getLocation() {
            return location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        @Override
        public CreateTrafficPolicyInstanceResponse build() {
            return new CreateTrafficPolicyInstanceResponse(this);
        }
    }
}
