/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This action deletes a health check.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DeleteHealthCheckRequest extends Route53Request implements
        ToCopyableBuilder<DeleteHealthCheckRequest.Builder, DeleteHealthCheckRequest> {
    private final String healthCheckId;

    private DeleteHealthCheckRequest(BuilderImpl builder) {
        super(builder);
        this.healthCheckId = builder.healthCheckId;
    }

    /**
     * <p>
     * The ID of the health check that you want to delete.
     * </p>
     * 
     * @return The ID of the health check that you want to delete.
     */
    public String healthCheckId() {
        return healthCheckId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(healthCheckId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteHealthCheckRequest)) {
            return false;
        }
        DeleteHealthCheckRequest other = (DeleteHealthCheckRequest) obj;
        return Objects.equals(healthCheckId(), other.healthCheckId());
    }

    @Override
    public String toString() {
        return ToString.builder("DeleteHealthCheckRequest").add("HealthCheckId", healthCheckId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HealthCheckId":
            return Optional.of(clazz.cast(healthCheckId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends Route53Request.Builder, CopyableBuilder<Builder, DeleteHealthCheckRequest> {
        /**
         * <p>
         * The ID of the health check that you want to delete.
         * </p>
         * 
         * @param healthCheckId
         *        The ID of the health check that you want to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthCheckId(String healthCheckId);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends Route53Request.BuilderImpl implements Builder {
        private String healthCheckId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteHealthCheckRequest model) {
            healthCheckId(model.healthCheckId);
        }

        public final String getHealthCheckId() {
            return healthCheckId;
        }

        @Override
        public final Builder healthCheckId(String healthCheckId) {
            this.healthCheckId = healthCheckId;
            return this;
        }

        public final void setHealthCheckId(String healthCheckId) {
            this.healthCheckId = healthCheckId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DeleteHealthCheckRequest build() {
            return new DeleteHealthCheckRequest(this);
        }
    }
}
