/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains information about the resource record sets that Amazon Route 53 created based on a
 * specified traffic policy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class GetTrafficPolicyInstanceCountResponse extends Route53Response implements
        ToCopyableBuilder<GetTrafficPolicyInstanceCountResponse.Builder, GetTrafficPolicyInstanceCountResponse> {
    private final Integer trafficPolicyInstanceCount;

    private GetTrafficPolicyInstanceCountResponse(BuilderImpl builder) {
        super(builder);
        this.trafficPolicyInstanceCount = builder.trafficPolicyInstanceCount;
    }

    /**
     * <p>
     * The number of traffic policy instances that are associated with the current AWS account.
     * </p>
     * 
     * @return The number of traffic policy instances that are associated with the current AWS account.
     */
    public Integer trafficPolicyInstanceCount() {
        return trafficPolicyInstanceCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(trafficPolicyInstanceCount());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTrafficPolicyInstanceCountResponse)) {
            return false;
        }
        GetTrafficPolicyInstanceCountResponse other = (GetTrafficPolicyInstanceCountResponse) obj;
        return Objects.equals(trafficPolicyInstanceCount(), other.trafficPolicyInstanceCount());
    }

    @Override
    public String toString() {
        return ToString.builder("GetTrafficPolicyInstanceCountResponse")
                .add("TrafficPolicyInstanceCount", trafficPolicyInstanceCount()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TrafficPolicyInstanceCount":
            return Optional.of(clazz.cast(trafficPolicyInstanceCount()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends Route53Response.Builder, CopyableBuilder<Builder, GetTrafficPolicyInstanceCountResponse> {
        /**
         * <p>
         * The number of traffic policy instances that are associated with the current AWS account.
         * </p>
         * 
         * @param trafficPolicyInstanceCount
         *        The number of traffic policy instances that are associated with the current AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trafficPolicyInstanceCount(Integer trafficPolicyInstanceCount);
    }

    static final class BuilderImpl extends Route53Response.BuilderImpl implements Builder {
        private Integer trafficPolicyInstanceCount;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTrafficPolicyInstanceCountResponse model) {
            trafficPolicyInstanceCount(model.trafficPolicyInstanceCount);
        }

        public final Integer getTrafficPolicyInstanceCount() {
            return trafficPolicyInstanceCount;
        }

        @Override
        public final Builder trafficPolicyInstanceCount(Integer trafficPolicyInstanceCount) {
            this.trafficPolicyInstanceCount = trafficPolicyInstanceCount;
            return this;
        }

        public final void setTrafficPolicyInstanceCount(Integer trafficPolicyInstanceCount) {
            this.trafficPolicyInstanceCount = trafficPolicyInstanceCount;
        }

        @Override
        public GetTrafficPolicyInstanceCountResponse build() {
            return new GetTrafficPolicyInstanceCountResponse(this);
        }
    }
}
