/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class ListQueryLoggingConfigsResponse extends Route53Response implements
        ToCopyableBuilder<ListQueryLoggingConfigsResponse.Builder, ListQueryLoggingConfigsResponse> {
    private final List<QueryLoggingConfig> queryLoggingConfigs;

    private final String nextToken;

    private ListQueryLoggingConfigsResponse(BuilderImpl builder) {
        super(builder);
        this.queryLoggingConfigs = builder.queryLoggingConfigs;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * An array that contains one <a>QueryLoggingConfig</a> element for each configuration for DNS query logging that is
     * associated with the current AWS account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array that contains one <a>QueryLoggingConfig</a> element for each configuration for DNS query logging
     *         that is associated with the current AWS account.
     */
    public List<QueryLoggingConfig> queryLoggingConfigs() {
        return queryLoggingConfigs;
    }

    /**
     * <p>
     * If a response includes the last of the query logging configurations that are associated with the current AWS
     * account, <code>NextToken</code> doesn't appear in the response.
     * </p>
     * <p>
     * If a response doesn't include the last of the configurations, you can get more configurations by submitting
     * another <a>ListQueryLoggingConfigs</a> request. Get the value of <code>NextToken</code> that Amazon Route 53
     * returned in the previous response and include it in <code>NextToken</code> in the next request.
     * </p>
     * 
     * @return If a response includes the last of the query logging configurations that are associated with the current
     *         AWS account, <code>NextToken</code> doesn't appear in the response.</p>
     *         <p>
     *         If a response doesn't include the last of the configurations, you can get more configurations by
     *         submitting another <a>ListQueryLoggingConfigs</a> request. Get the value of <code>NextToken</code> that
     *         Amazon Route 53 returned in the previous response and include it in <code>NextToken</code> in the next
     *         request.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(queryLoggingConfigs());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListQueryLoggingConfigsResponse)) {
            return false;
        }
        ListQueryLoggingConfigsResponse other = (ListQueryLoggingConfigsResponse) obj;
        return Objects.equals(queryLoggingConfigs(), other.queryLoggingConfigs())
                && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("ListQueryLoggingConfigsResponse").add("QueryLoggingConfigs", queryLoggingConfigs())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "QueryLoggingConfigs":
            return Optional.of(clazz.cast(queryLoggingConfigs()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends Route53Response.Builder, CopyableBuilder<Builder, ListQueryLoggingConfigsResponse> {
        /**
         * <p>
         * An array that contains one <a>QueryLoggingConfig</a> element for each configuration for DNS query logging
         * that is associated with the current AWS account.
         * </p>
         * 
         * @param queryLoggingConfigs
         *        An array that contains one <a>QueryLoggingConfig</a> element for each configuration for DNS query
         *        logging that is associated with the current AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryLoggingConfigs(Collection<QueryLoggingConfig> queryLoggingConfigs);

        /**
         * <p>
         * An array that contains one <a>QueryLoggingConfig</a> element for each configuration for DNS query logging
         * that is associated with the current AWS account.
         * </p>
         * 
         * @param queryLoggingConfigs
         *        An array that contains one <a>QueryLoggingConfig</a> element for each configuration for DNS query
         *        logging that is associated with the current AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryLoggingConfigs(QueryLoggingConfig... queryLoggingConfigs);

        /**
         * <p>
         * If a response includes the last of the query logging configurations that are associated with the current AWS
         * account, <code>NextToken</code> doesn't appear in the response.
         * </p>
         * <p>
         * If a response doesn't include the last of the configurations, you can get more configurations by submitting
         * another <a>ListQueryLoggingConfigs</a> request. Get the value of <code>NextToken</code> that Amazon Route 53
         * returned in the previous response and include it in <code>NextToken</code> in the next request.
         * </p>
         * 
         * @param nextToken
         *        If a response includes the last of the query logging configurations that are associated with the
         *        current AWS account, <code>NextToken</code> doesn't appear in the response.</p>
         *        <p>
         *        If a response doesn't include the last of the configurations, you can get more configurations by
         *        submitting another <a>ListQueryLoggingConfigs</a> request. Get the value of <code>NextToken</code>
         *        that Amazon Route 53 returned in the previous response and include it in <code>NextToken</code> in the
         *        next request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends Route53Response.BuilderImpl implements Builder {
        private List<QueryLoggingConfig> queryLoggingConfigs;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListQueryLoggingConfigsResponse model) {
            queryLoggingConfigs(model.queryLoggingConfigs);
            nextToken(model.nextToken);
        }

        public final Collection<QueryLoggingConfig.Builder> getQueryLoggingConfigs() {
            return queryLoggingConfigs != null ? queryLoggingConfigs.stream().map(QueryLoggingConfig::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder queryLoggingConfigs(Collection<QueryLoggingConfig> queryLoggingConfigs) {
            this.queryLoggingConfigs = QueryLoggingConfigsCopier.copy(queryLoggingConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queryLoggingConfigs(QueryLoggingConfig... queryLoggingConfigs) {
            queryLoggingConfigs(Arrays.asList(queryLoggingConfigs));
            return this;
        }

        public final void setQueryLoggingConfigs(Collection<QueryLoggingConfig.BuilderImpl> queryLoggingConfigs) {
            this.queryLoggingConfigs = QueryLoggingConfigsCopier.copyFromBuilder(queryLoggingConfigs);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListQueryLoggingConfigsResponse build() {
            return new ListQueryLoggingConfigsResponse(this);
        }
    }
}
