/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Gets the value that Amazon Route 53 returns in response to a DNS request for a specified record name and type. You
 * can optionally specify the IP address of a DNS resolver, an EDNS0 client subnet IP address, and a subnet mask.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class TestDNSAnswerRequest extends Route53Request implements
        ToCopyableBuilder<TestDNSAnswerRequest.Builder, TestDNSAnswerRequest> {
    private final String hostedZoneId;

    private final String recordName;

    private final String recordType;

    private final String resolverIP;

    private final String edns0ClientSubnetIP;

    private final String edns0ClientSubnetMask;

    private TestDNSAnswerRequest(BuilderImpl builder) {
        super(builder);
        this.hostedZoneId = builder.hostedZoneId;
        this.recordName = builder.recordName;
        this.recordType = builder.recordType;
        this.resolverIP = builder.resolverIP;
        this.edns0ClientSubnetIP = builder.edns0ClientSubnetIP;
        this.edns0ClientSubnetMask = builder.edns0ClientSubnetMask;
    }

    /**
     * <p>
     * The ID of the hosted zone that you want Amazon Route 53 to simulate a query for.
     * </p>
     * 
     * @return The ID of the hosted zone that you want Amazon Route 53 to simulate a query for.
     */
    public String hostedZoneId() {
        return hostedZoneId;
    }

    /**
     * <p>
     * The name of the resource record set that you want Amazon Route 53 to simulate a query for.
     * </p>
     * 
     * @return The name of the resource record set that you want Amazon Route 53 to simulate a query for.
     */
    public String recordName() {
        return recordName;
    }

    /**
     * <p>
     * The type of the resource record set.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #recordType} will
     * return {@link RRType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #recordTypeString}.
     * </p>
     * 
     * @return The type of the resource record set.
     * @see RRType
     */
    public RRType recordType() {
        return RRType.fromValue(recordType);
    }

    /**
     * <p>
     * The type of the resource record set.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #recordType} will
     * return {@link RRType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #recordTypeString}.
     * </p>
     * 
     * @return The type of the resource record set.
     * @see RRType
     */
    public String recordTypeString() {
        return recordType;
    }

    /**
     * <p>
     * If you want to simulate a request from a specific DNS resolver, specify the IP address for that resolver. If you
     * omit this value, <code>TestDnsAnswer</code> uses the IP address of a DNS resolver in the AWS US East (N.
     * Virginia) Region (<code>us-east-1</code>).
     * </p>
     * 
     * @return If you want to simulate a request from a specific DNS resolver, specify the IP address for that resolver.
     *         If you omit this value, <code>TestDnsAnswer</code> uses the IP address of a DNS resolver in the AWS US
     *         East (N. Virginia) Region (<code>us-east-1</code>).
     */
    public String resolverIP() {
        return resolverIP;
    }

    /**
     * <p>
     * If the resolver that you specified for resolverip supports EDNS0, specify the IPv4 or IPv6 address of a client in
     * the applicable location, for example, <code>192.0.2.44</code> or <code>2001:db8:85a3::8a2e:370:7334</code>.
     * </p>
     * 
     * @return If the resolver that you specified for resolverip supports EDNS0, specify the IPv4 or IPv6 address of a
     *         client in the applicable location, for example, <code>192.0.2.44</code> or
     *         <code>2001:db8:85a3::8a2e:370:7334</code>.
     */
    public String edns0ClientSubnetIP() {
        return edns0ClientSubnetIP;
    }

    /**
     * <p>
     * If you specify an IP address for <code>edns0clientsubnetip</code>, you can optionally specify the number of bits
     * of the IP address that you want the checking tool to include in the DNS query. For example, if you specify
     * <code>192.0.2.44</code> for <code>edns0clientsubnetip</code> and <code>24</code> for
     * <code>edns0clientsubnetmask</code>, the checking tool will simulate a request from 192.0.2.0/24. The default
     * value is 24 bits for IPv4 addresses and 64 bits for IPv6 addresses.
     * </p>
     * 
     * @return If you specify an IP address for <code>edns0clientsubnetip</code>, you can optionally specify the number
     *         of bits of the IP address that you want the checking tool to include in the DNS query. For example, if
     *         you specify <code>192.0.2.44</code> for <code>edns0clientsubnetip</code> and <code>24</code> for
     *         <code>edns0clientsubnetmask</code>, the checking tool will simulate a request from 192.0.2.0/24. The
     *         default value is 24 bits for IPv4 addresses and 64 bits for IPv6 addresses.
     */
    public String edns0ClientSubnetMask() {
        return edns0ClientSubnetMask;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hostedZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(recordName());
        hashCode = 31 * hashCode + Objects.hashCode(recordTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(resolverIP());
        hashCode = 31 * hashCode + Objects.hashCode(edns0ClientSubnetIP());
        hashCode = 31 * hashCode + Objects.hashCode(edns0ClientSubnetMask());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestDNSAnswerRequest)) {
            return false;
        }
        TestDNSAnswerRequest other = (TestDNSAnswerRequest) obj;
        return Objects.equals(hostedZoneId(), other.hostedZoneId()) && Objects.equals(recordName(), other.recordName())
                && Objects.equals(recordTypeString(), other.recordTypeString())
                && Objects.equals(resolverIP(), other.resolverIP())
                && Objects.equals(edns0ClientSubnetIP(), other.edns0ClientSubnetIP())
                && Objects.equals(edns0ClientSubnetMask(), other.edns0ClientSubnetMask());
    }

    @Override
    public String toString() {
        return ToString.builder("TestDNSAnswerRequest").add("HostedZoneId", hostedZoneId()).add("RecordName", recordName())
                .add("RecordType", recordTypeString()).add("ResolverIP", resolverIP())
                .add("EDNS0ClientSubnetIP", edns0ClientSubnetIP()).add("EDNS0ClientSubnetMask", edns0ClientSubnetMask()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HostedZoneId":
            return Optional.of(clazz.cast(hostedZoneId()));
        case "RecordName":
            return Optional.of(clazz.cast(recordName()));
        case "RecordType":
            return Optional.of(clazz.cast(recordTypeString()));
        case "ResolverIP":
            return Optional.of(clazz.cast(resolverIP()));
        case "EDNS0ClientSubnetIP":
            return Optional.of(clazz.cast(edns0ClientSubnetIP()));
        case "EDNS0ClientSubnetMask":
            return Optional.of(clazz.cast(edns0ClientSubnetMask()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends Route53Request.Builder, CopyableBuilder<Builder, TestDNSAnswerRequest> {
        /**
         * <p>
         * The ID of the hosted zone that you want Amazon Route 53 to simulate a query for.
         * </p>
         * 
         * @param hostedZoneId
         *        The ID of the hosted zone that you want Amazon Route 53 to simulate a query for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostedZoneId(String hostedZoneId);

        /**
         * <p>
         * The name of the resource record set that you want Amazon Route 53 to simulate a query for.
         * </p>
         * 
         * @param recordName
         *        The name of the resource record set that you want Amazon Route 53 to simulate a query for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordName(String recordName);

        /**
         * <p>
         * The type of the resource record set.
         * </p>
         * 
         * @param recordType
         *        The type of the resource record set.
         * @see RRType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RRType
         */
        Builder recordType(String recordType);

        /**
         * <p>
         * The type of the resource record set.
         * </p>
         * 
         * @param recordType
         *        The type of the resource record set.
         * @see RRType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RRType
         */
        Builder recordType(RRType recordType);

        /**
         * <p>
         * If you want to simulate a request from a specific DNS resolver, specify the IP address for that resolver. If
         * you omit this value, <code>TestDnsAnswer</code> uses the IP address of a DNS resolver in the AWS US East (N.
         * Virginia) Region (<code>us-east-1</code>).
         * </p>
         * 
         * @param resolverIP
         *        If you want to simulate a request from a specific DNS resolver, specify the IP address for that
         *        resolver. If you omit this value, <code>TestDnsAnswer</code> uses the IP address of a DNS resolver in
         *        the AWS US East (N. Virginia) Region (<code>us-east-1</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resolverIP(String resolverIP);

        /**
         * <p>
         * If the resolver that you specified for resolverip supports EDNS0, specify the IPv4 or IPv6 address of a
         * client in the applicable location, for example, <code>192.0.2.44</code> or
         * <code>2001:db8:85a3::8a2e:370:7334</code>.
         * </p>
         * 
         * @param edns0ClientSubnetIP
         *        If the resolver that you specified for resolverip supports EDNS0, specify the IPv4 or IPv6 address of
         *        a client in the applicable location, for example, <code>192.0.2.44</code> or
         *        <code>2001:db8:85a3::8a2e:370:7334</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder edns0ClientSubnetIP(String edns0ClientSubnetIP);

        /**
         * <p>
         * If you specify an IP address for <code>edns0clientsubnetip</code>, you can optionally specify the number of
         * bits of the IP address that you want the checking tool to include in the DNS query. For example, if you
         * specify <code>192.0.2.44</code> for <code>edns0clientsubnetip</code> and <code>24</code> for
         * <code>edns0clientsubnetmask</code>, the checking tool will simulate a request from 192.0.2.0/24. The default
         * value is 24 bits for IPv4 addresses and 64 bits for IPv6 addresses.
         * </p>
         * 
         * @param edns0ClientSubnetMask
         *        If you specify an IP address for <code>edns0clientsubnetip</code>, you can optionally specify the
         *        number of bits of the IP address that you want the checking tool to include in the DNS query. For
         *        example, if you specify <code>192.0.2.44</code> for <code>edns0clientsubnetip</code> and
         *        <code>24</code> for <code>edns0clientsubnetmask</code>, the checking tool will simulate a request from
         *        192.0.2.0/24. The default value is 24 bits for IPv4 addresses and 64 bits for IPv6 addresses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder edns0ClientSubnetMask(String edns0ClientSubnetMask);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends Route53Request.BuilderImpl implements Builder {
        private String hostedZoneId;

        private String recordName;

        private String recordType;

        private String resolverIP;

        private String edns0ClientSubnetIP;

        private String edns0ClientSubnetMask;

        private BuilderImpl() {
        }

        private BuilderImpl(TestDNSAnswerRequest model) {
            hostedZoneId(model.hostedZoneId);
            recordName(model.recordName);
            recordType(model.recordType);
            resolverIP(model.resolverIP);
            edns0ClientSubnetIP(model.edns0ClientSubnetIP);
            edns0ClientSubnetMask(model.edns0ClientSubnetMask);
        }

        public final String getHostedZoneId() {
            return hostedZoneId;
        }

        @Override
        public final Builder hostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
            return this;
        }

        public final void setHostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
        }

        public final String getRecordName() {
            return recordName;
        }

        @Override
        public final Builder recordName(String recordName) {
            this.recordName = recordName;
            return this;
        }

        public final void setRecordName(String recordName) {
            this.recordName = recordName;
        }

        public final String getRecordType() {
            return recordType;
        }

        @Override
        public final Builder recordType(String recordType) {
            this.recordType = recordType;
            return this;
        }

        @Override
        public final Builder recordType(RRType recordType) {
            this.recordType(recordType.toString());
            return this;
        }

        public final void setRecordType(String recordType) {
            this.recordType = recordType;
        }

        public final String getResolverIP() {
            return resolverIP;
        }

        @Override
        public final Builder resolverIP(String resolverIP) {
            this.resolverIP = resolverIP;
            return this;
        }

        public final void setResolverIP(String resolverIP) {
            this.resolverIP = resolverIP;
        }

        public final String getEDNS0ClientSubnetIP() {
            return edns0ClientSubnetIP;
        }

        @Override
        public final Builder edns0ClientSubnetIP(String edns0ClientSubnetIP) {
            this.edns0ClientSubnetIP = edns0ClientSubnetIP;
            return this;
        }

        public final void setEDNS0ClientSubnetIP(String edns0ClientSubnetIP) {
            this.edns0ClientSubnetIP = edns0ClientSubnetIP;
        }

        public final String getEDNS0ClientSubnetMask() {
            return edns0ClientSubnetMask;
        }

        @Override
        public final Builder edns0ClientSubnetMask(String edns0ClientSubnetMask) {
            this.edns0ClientSubnetMask = edns0ClientSubnetMask;
            return this;
        }

        public final void setEDNS0ClientSubnetMask(String edns0ClientSubnetMask) {
            this.edns0ClientSubnetMask = edns0ClientSubnetMask;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public TestDNSAnswerRequest build() {
            return new TestDNSAnswerRequest(this);
        }
    }
}
