/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains settings for a traffic policy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class TrafficPolicy implements ToCopyableBuilder<TrafficPolicy.Builder, TrafficPolicy> {
    private final String id;

    private final Integer version;

    private final String name;

    private final String type;

    private final String document;

    private final String comment;

    private TrafficPolicy(BuilderImpl builder) {
        this.id = builder.id;
        this.version = builder.version;
        this.name = builder.name;
        this.type = builder.type;
        this.document = builder.document;
        this.comment = builder.comment;
    }

    /**
     * <p>
     * The ID that Amazon Route 53 assigned to a traffic policy when you created it.
     * </p>
     * 
     * @return The ID that Amazon Route 53 assigned to a traffic policy when you created it.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * The version number that Amazon Route 53 assigns to a traffic policy. For a new traffic policy, the value of
     * <code>Version</code> is always 1.
     * </p>
     * 
     * @return The version number that Amazon Route 53 assigns to a traffic policy. For a new traffic policy, the value
     *         of <code>Version</code> is always 1.
     */
    public Integer version() {
        return version;
    }

    /**
     * <p>
     * The name that you specified when you created the traffic policy.
     * </p>
     * 
     * @return The name that you specified when you created the traffic policy.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The DNS type of the resource record sets that Amazon Route 53 creates when you use a traffic policy to create a
     * traffic policy instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RRType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeString}.
     * </p>
     * 
     * @return The DNS type of the resource record sets that Amazon Route 53 creates when you use a traffic policy to
     *         create a traffic policy instance.
     * @see RRType
     */
    public RRType type() {
        return RRType.fromValue(type);
    }

    /**
     * <p>
     * The DNS type of the resource record sets that Amazon Route 53 creates when you use a traffic policy to create a
     * traffic policy instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RRType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeString}.
     * </p>
     * 
     * @return The DNS type of the resource record sets that Amazon Route 53 creates when you use a traffic policy to
     *         create a traffic policy instance.
     * @see RRType
     */
    public String typeString() {
        return type;
    }

    /**
     * <p>
     * The definition of a traffic policy in JSON format. You specify the JSON document to use for a new traffic policy
     * in the <code>CreateTrafficPolicy</code> request. For more information about the JSON format, see <a
     * href="http://docs.aws.amazon.com/Route53/latest/APIReference/api-policies-traffic-policy-document-format.html"
     * >Traffic Policy Document Format</a>.
     * </p>
     * 
     * @return The definition of a traffic policy in JSON format. You specify the JSON document to use for a new traffic
     *         policy in the <code>CreateTrafficPolicy</code> request. For more information about the JSON format, see
     *         <a href=
     *         "http://docs.aws.amazon.com/Route53/latest/APIReference/api-policies-traffic-policy-document-format.html"
     *         >Traffic Policy Document Format</a>.
     */
    public String document() {
        return document;
    }

    /**
     * <p>
     * The comment that you specify in the <code>CreateTrafficPolicy</code> request, if any.
     * </p>
     * 
     * @return The comment that you specify in the <code>CreateTrafficPolicy</code> request, if any.
     */
    public String comment() {
        return comment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(typeString());
        hashCode = 31 * hashCode + Objects.hashCode(document());
        hashCode = 31 * hashCode + Objects.hashCode(comment());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrafficPolicy)) {
            return false;
        }
        TrafficPolicy other = (TrafficPolicy) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(version(), other.version())
                && Objects.equals(name(), other.name()) && Objects.equals(typeString(), other.typeString())
                && Objects.equals(document(), other.document()) && Objects.equals(comment(), other.comment());
    }

    @Override
    public String toString() {
        return ToString.builder("TrafficPolicy").add("Id", id()).add("Version", version()).add("Name", name())
                .add("Type", typeString()).add("Document", document()).add("Comment", comment()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.of(clazz.cast(id()));
        case "Version":
            return Optional.of(clazz.cast(version()));
        case "Name":
            return Optional.of(clazz.cast(name()));
        case "Type":
            return Optional.of(clazz.cast(typeString()));
        case "Document":
            return Optional.of(clazz.cast(document()));
        case "Comment":
            return Optional.of(clazz.cast(comment()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, TrafficPolicy> {
        /**
         * <p>
         * The ID that Amazon Route 53 assigned to a traffic policy when you created it.
         * </p>
         * 
         * @param id
         *        The ID that Amazon Route 53 assigned to a traffic policy when you created it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The version number that Amazon Route 53 assigns to a traffic policy. For a new traffic policy, the value of
         * <code>Version</code> is always 1.
         * </p>
         * 
         * @param version
         *        The version number that Amazon Route 53 assigns to a traffic policy. For a new traffic policy, the
         *        value of <code>Version</code> is always 1.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(Integer version);

        /**
         * <p>
         * The name that you specified when you created the traffic policy.
         * </p>
         * 
         * @param name
         *        The name that you specified when you created the traffic policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The DNS type of the resource record sets that Amazon Route 53 creates when you use a traffic policy to create
         * a traffic policy instance.
         * </p>
         * 
         * @param type
         *        The DNS type of the resource record sets that Amazon Route 53 creates when you use a traffic policy to
         *        create a traffic policy instance.
         * @see RRType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RRType
         */
        Builder type(String type);

        /**
         * <p>
         * The DNS type of the resource record sets that Amazon Route 53 creates when you use a traffic policy to create
         * a traffic policy instance.
         * </p>
         * 
         * @param type
         *        The DNS type of the resource record sets that Amazon Route 53 creates when you use a traffic policy to
         *        create a traffic policy instance.
         * @see RRType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RRType
         */
        Builder type(RRType type);

        /**
         * <p>
         * The definition of a traffic policy in JSON format. You specify the JSON document to use for a new traffic
         * policy in the <code>CreateTrafficPolicy</code> request. For more information about the JSON format, see <a
         * href
         * ="http://docs.aws.amazon.com/Route53/latest/APIReference/api-policies-traffic-policy-document-format.html"
         * >Traffic Policy Document Format</a>.
         * </p>
         * 
         * @param document
         *        The definition of a traffic policy in JSON format. You specify the JSON document to use for a new
         *        traffic policy in the <code>CreateTrafficPolicy</code> request. For more information about the JSON
         *        format, see <a href=
         *        "http://docs.aws.amazon.com/Route53/latest/APIReference/api-policies-traffic-policy-document-format.html"
         *        >Traffic Policy Document Format</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder document(String document);

        /**
         * <p>
         * The comment that you specify in the <code>CreateTrafficPolicy</code> request, if any.
         * </p>
         * 
         * @param comment
         *        The comment that you specify in the <code>CreateTrafficPolicy</code> request, if any.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comment(String comment);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private Integer version;

        private String name;

        private String type;

        private String document;

        private String comment;

        private BuilderImpl() {
        }

        private BuilderImpl(TrafficPolicy model) {
            id(model.id);
            version(model.version);
            name(model.name);
            type(model.type);
            document(model.document);
            comment(model.comment);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final Integer getVersion() {
            return version;
        }

        @Override
        public final Builder version(Integer version) {
            this.version = version;
            return this;
        }

        public final void setVersion(Integer version) {
            this.version = version;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(RRType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getDocument() {
            return document;
        }

        @Override
        public final Builder document(String document) {
            this.document = document;
            return this;
        }

        public final void setDocument(String document) {
            this.document = document;
        }

        public final String getComment() {
            return comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        @Override
        public TrafficPolicy build() {
            return new TrafficPolicy(this);
        }
    }
}
