/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.route53.model.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * ChangeBatch StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ChangeBatchUnmarshaller implements Unmarshaller<ChangeBatch, StaxUnmarshallerContext> {

    public ChangeBatch unmarshall(StaxUnmarshallerContext context) throws Exception {
        ChangeBatch.Builder changeBatch = ChangeBatch.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<Change> changes = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                changeBatch.changes(changes);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("Comment", targetDepth)) {
                    changeBatch.comment(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Changes", targetDepth)) {
                    changes = new ArrayList<Change>();
                    continue;
                }

                if (context.testExpression("Changes/Change", targetDepth)) {
                    changes.add(ChangeUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    changeBatch.changes(changes);
                    break;
                }
            }
        }
        return changeBatch.build();
    }

    private static final ChangeBatchUnmarshaller INSTANCE = new ChangeBatchUnmarshaller();

    public static ChangeBatchUnmarshaller getInstance() {
        return INSTANCE;
    }
}
