/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.transform;

import static software.amazon.awssdk.core.util.StringUtils.UTF8;

import java.io.StringWriter;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.route53.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;

import software.amazon.awssdk.core.util.StringInputStream;

import software.amazon.awssdk.core.util.XmlWriter;

/**
 * CreateHealthCheckRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class CreateHealthCheckRequestMarshaller implements
        Marshaller<Request<CreateHealthCheckRequest>, CreateHealthCheckRequest> {

    public Request<CreateHealthCheckRequest> marshall(CreateHealthCheckRequest createHealthCheckRequest) {

        if (createHealthCheckRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<CreateHealthCheckRequest> request = new DefaultRequest<CreateHealthCheckRequest>(createHealthCheckRequest,
                "Route53Client");

        request.setHttpMethod(HttpMethodName.POST);

        String uriResourcePath = "/2013-04-01/healthcheck";

        request.setResourcePath(uriResourcePath);

        try {
            StringWriter stringWriter = new StringWriter();
            XmlWriter xmlWriter = new XmlWriter(stringWriter, "https://route53.amazonaws.com/doc/2013-04-01/");

            xmlWriter.startElement("CreateHealthCheckRequest");

            if (createHealthCheckRequest.callerReference() != null) {
                xmlWriter.startElement("CallerReference").value(createHealthCheckRequest.callerReference()).endElement();
            }

            HealthCheckConfig healthCheckConfig = createHealthCheckRequest.healthCheckConfig();
            if (healthCheckConfig != null) {
                xmlWriter.startElement("HealthCheckConfig");

                if (healthCheckConfig.ipAddress() != null) {
                    xmlWriter.startElement("IPAddress").value(healthCheckConfig.ipAddress()).endElement();
                }

                if (healthCheckConfig.port() != null) {
                    xmlWriter.startElement("Port").value(healthCheckConfig.port()).endElement();
                }

                if (healthCheckConfig.typeString() != null) {
                    xmlWriter.startElement("Type").value(healthCheckConfig.typeString()).endElement();
                }

                if (healthCheckConfig.resourcePath() != null) {
                    xmlWriter.startElement("ResourcePath").value(healthCheckConfig.resourcePath()).endElement();
                }

                if (healthCheckConfig.fullyQualifiedDomainName() != null) {
                    xmlWriter.startElement("FullyQualifiedDomainName").value(healthCheckConfig.fullyQualifiedDomainName())
                            .endElement();
                }

                if (healthCheckConfig.searchString() != null) {
                    xmlWriter.startElement("SearchString").value(healthCheckConfig.searchString()).endElement();
                }

                if (healthCheckConfig.requestInterval() != null) {
                    xmlWriter.startElement("RequestInterval").value(healthCheckConfig.requestInterval()).endElement();
                }

                if (healthCheckConfig.failureThreshold() != null) {
                    xmlWriter.startElement("FailureThreshold").value(healthCheckConfig.failureThreshold()).endElement();
                }

                if (healthCheckConfig.measureLatency() != null) {
                    xmlWriter.startElement("MeasureLatency").value(healthCheckConfig.measureLatency()).endElement();
                }

                if (healthCheckConfig.inverted() != null) {
                    xmlWriter.startElement("Inverted").value(healthCheckConfig.inverted()).endElement();
                }

                if (healthCheckConfig.healthThreshold() != null) {
                    xmlWriter.startElement("HealthThreshold").value(healthCheckConfig.healthThreshold()).endElement();
                }

                java.util.List<String> healthCheckConfigChildHealthChecksList = healthCheckConfig.childHealthChecks();
                if (healthCheckConfigChildHealthChecksList != null) {
                    xmlWriter.startElement("ChildHealthChecks");

                    for (String healthCheckConfigChildHealthChecksListValue : healthCheckConfigChildHealthChecksList) {
                        xmlWriter.startElement("ChildHealthCheck");
                        xmlWriter.value(healthCheckConfigChildHealthChecksListValue);
                        xmlWriter.endElement();
                    }
                    xmlWriter.endElement();
                }

                if (healthCheckConfig.enableSNI() != null) {
                    xmlWriter.startElement("EnableSNI").value(healthCheckConfig.enableSNI()).endElement();
                }

                java.util.List<String> healthCheckConfigRegionsList = healthCheckConfig.regionsStrings();
                if (healthCheckConfigRegionsList != null) {
                    xmlWriter.startElement("Regions");

                    for (String healthCheckConfigRegionsListValue : healthCheckConfigRegionsList) {
                        xmlWriter.startElement("Region");
                        xmlWriter.value(healthCheckConfigRegionsListValue);
                        xmlWriter.endElement();
                    }
                    xmlWriter.endElement();
                }

                AlarmIdentifier alarmIdentifier = healthCheckConfig.alarmIdentifier();
                if (alarmIdentifier != null) {
                    xmlWriter.startElement("AlarmIdentifier");

                    if (alarmIdentifier.regionString() != null) {
                        xmlWriter.startElement("Region").value(alarmIdentifier.regionString()).endElement();
                    }

                    if (alarmIdentifier.name() != null) {
                        xmlWriter.startElement("Name").value(alarmIdentifier.name()).endElement();
                    }
                    xmlWriter.endElement();
                }

                if (healthCheckConfig.insufficientDataHealthStatusString() != null) {
                    xmlWriter.startElement("InsufficientDataHealthStatus")
                            .value(healthCheckConfig.insufficientDataHealthStatusString()).endElement();
                }
                xmlWriter.endElement();
            }
            xmlWriter.endElement();

            request.setContent(new StringInputStream(stringWriter.getBuffer().toString()));
            request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(UTF8).length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        } catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to XML: " + t.getMessage(), t);
        }

        return request;
    }

}