/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.transform;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.route53.model.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * CreateHostedZoneResponse StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class CreateHostedZoneResponseUnmarshaller implements Unmarshaller<CreateHostedZoneResponse, StaxUnmarshallerContext> {

    public CreateHostedZoneResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        CreateHostedZoneResponse.Builder createHostedZoneResponse = CreateHostedZoneResponse.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        if (context.isStartOfDocument()) {
            context.setCurrentHeader("Location");
            createHostedZoneResponse.location(StringUnmarshaller.getInstance().unmarshall(context));

        }

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("HostedZone", targetDepth)) {
                    createHostedZoneResponse.hostedZone(HostedZoneUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("ChangeInfo", targetDepth)) {
                    createHostedZoneResponse.changeInfo(ChangeInfoUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("DelegationSet", targetDepth)) {
                    createHostedZoneResponse.delegationSet(DelegationSetUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("VPC", targetDepth)) {
                    createHostedZoneResponse.vpc(VPCUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    break;
                }
            }
        }
        return createHostedZoneResponse.build();
    }

    private static final CreateHostedZoneResponseUnmarshaller INSTANCE = new CreateHostedZoneResponseUnmarshaller();

    public static CreateHostedZoneResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
