/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.route53.model.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * GetHealthCheckLastFailureReasonResponse StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class GetHealthCheckLastFailureReasonResponseUnmarshaller implements
        Unmarshaller<GetHealthCheckLastFailureReasonResponse, StaxUnmarshallerContext> {

    public GetHealthCheckLastFailureReasonResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        GetHealthCheckLastFailureReasonResponse.Builder getHealthCheckLastFailureReasonResponse = GetHealthCheckLastFailureReasonResponse
                .builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<HealthCheckObservation> healthCheckObservations = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                getHealthCheckLastFailureReasonResponse.healthCheckObservations(healthCheckObservations);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("HealthCheckObservations", targetDepth)) {
                    healthCheckObservations = new ArrayList<HealthCheckObservation>();
                    continue;
                }

                if (context.testExpression("HealthCheckObservations/HealthCheckObservation", targetDepth)) {
                    healthCheckObservations.add(HealthCheckObservationUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    getHealthCheckLastFailureReasonResponse.healthCheckObservations(healthCheckObservations);
                    break;
                }
            }
        }
        return getHealthCheckLastFailureReasonResponse.build();
    }

    private static final GetHealthCheckLastFailureReasonResponseUnmarshaller INSTANCE = new GetHealthCheckLastFailureReasonResponseUnmarshaller();

    public static GetHealthCheckLastFailureReasonResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
