/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.route53.model.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * ListHostedZonesByNameResponse StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ListHostedZonesByNameResponseUnmarshaller implements
        Unmarshaller<ListHostedZonesByNameResponse, StaxUnmarshallerContext> {

    public ListHostedZonesByNameResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        ListHostedZonesByNameResponse.Builder listHostedZonesByNameResponse = ListHostedZonesByNameResponse.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<HostedZone> hostedZones = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                listHostedZonesByNameResponse.hostedZones(hostedZones);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("HostedZones", targetDepth)) {
                    hostedZones = new ArrayList<HostedZone>();
                    continue;
                }

                if (context.testExpression("HostedZones/HostedZone", targetDepth)) {
                    hostedZones.add(HostedZoneUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("DNSName", targetDepth)) {
                    listHostedZonesByNameResponse.dnsName(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("HostedZoneId", targetDepth)) {
                    listHostedZonesByNameResponse.hostedZoneId(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("IsTruncated", targetDepth)) {
                    listHostedZonesByNameResponse.isTruncated(BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("NextDNSName", targetDepth)) {
                    listHostedZonesByNameResponse.nextDNSName(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("NextHostedZoneId", targetDepth)) {
                    listHostedZonesByNameResponse.nextHostedZoneId(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("MaxItems", targetDepth)) {
                    listHostedZonesByNameResponse.maxItems(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    listHostedZonesByNameResponse.hostedZones(hostedZones);
                    break;
                }
            }
        }
        return listHostedZonesByNameResponse.build();
    }

    private static final ListHostedZonesByNameResponseUnmarshaller INSTANCE = new ListHostedZonesByNameResponseUnmarshaller();

    public static ListHostedZonesByNameResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
