/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53domains.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The CheckDomainAvailability request contains the following elements.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CheckDomainAvailabilityRequest extends Route53DomainsRequest implements
        ToCopyableBuilder<CheckDomainAvailabilityRequest.Builder, CheckDomainAvailabilityRequest> {
    private final String domainName;

    private final String idnLangCode;

    private CheckDomainAvailabilityRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.idnLangCode = builder.idnLangCode;
    }

    /**
     * <p>
     * The name of the domain that you want to get availability for.
     * </p>
     * <p>
     * Constraints: The domain name can contain only the letters a through z, the numbers 0 through 9, and hyphen (-).
     * Internationalized Domain Names are not supported.
     * </p>
     * 
     * @return The name of the domain that you want to get availability for.</p>
     *         <p>
     *         Constraints: The domain name can contain only the letters a through z, the numbers 0 through 9, and
     *         hyphen (-). Internationalized Domain Names are not supported.
     */
    public String domainName() {
        return domainName;
    }

    /**
     * <p>
     * Reserved for future use.
     * </p>
     * 
     * @return Reserved for future use.
     */
    public String idnLangCode() {
        return idnLangCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(idnLangCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CheckDomainAvailabilityRequest)) {
            return false;
        }
        CheckDomainAvailabilityRequest other = (CheckDomainAvailabilityRequest) obj;
        return Objects.equals(domainName(), other.domainName()) && Objects.equals(idnLangCode(), other.idnLangCode());
    }

    @Override
    public String toString() {
        return ToString.builder("CheckDomainAvailabilityRequest").add("DomainName", domainName())
                .add("IdnLangCode", idnLangCode()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainName":
            return Optional.of(clazz.cast(domainName()));
        case "IdnLangCode":
            return Optional.of(clazz.cast(idnLangCode()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends Route53DomainsRequest.Builder, CopyableBuilder<Builder, CheckDomainAvailabilityRequest> {
        /**
         * <p>
         * The name of the domain that you want to get availability for.
         * </p>
         * <p>
         * Constraints: The domain name can contain only the letters a through z, the numbers 0 through 9, and hyphen
         * (-). Internationalized Domain Names are not supported.
         * </p>
         * 
         * @param domainName
         *        The name of the domain that you want to get availability for.</p>
         *        <p>
         *        Constraints: The domain name can contain only the letters a through z, the numbers 0 through 9, and
         *        hyphen (-). Internationalized Domain Names are not supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * Reserved for future use.
         * </p>
         * 
         * @param idnLangCode
         *        Reserved for future use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idnLangCode(String idnLangCode);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends Route53DomainsRequest.BuilderImpl implements Builder {
        private String domainName;

        private String idnLangCode;

        private BuilderImpl() {
        }

        private BuilderImpl(CheckDomainAvailabilityRequest model) {
            domainName(model.domainName);
            idnLangCode(model.idnLangCode);
        }

        public final String getDomainName() {
            return domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final String getIdnLangCode() {
            return idnLangCode;
        }

        @Override
        public final Builder idnLangCode(String idnLangCode) {
            this.idnLangCode = idnLangCode;
            return this;
        }

        public final void setIdnLangCode(String idnLangCode) {
            this.idnLangCode = idnLangCode;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CheckDomainAvailabilityRequest build() {
            return new CheckDomainAvailabilityRequest(this);
        }
    }
}
