/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53domains.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.route53domains.transform.ExtraParamMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * ExtraParam includes the following elements.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ExtraParam implements StructuredPojo, ToCopyableBuilder<ExtraParam.Builder, ExtraParam> {
    private final String name;

    private final String value;

    private ExtraParam(BuilderImpl builder) {
        this.name = builder.name;
        this.value = builder.value;
    }

    /**
     * <p>
     * Name of the additional parameter required by the top-level domain.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link ExtraParamName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nameString}.
     * </p>
     * 
     * @return Name of the additional parameter required by the top-level domain.
     * @see ExtraParamName
     */
    public ExtraParamName name() {
        return ExtraParamName.fromValue(name);
    }

    /**
     * <p>
     * Name of the additional parameter required by the top-level domain.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link ExtraParamName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nameString}.
     * </p>
     * 
     * @return Name of the additional parameter required by the top-level domain.
     * @see ExtraParamName
     */
    public String nameString() {
        return name;
    }

    /**
     * <p>
     * Values corresponding to the additional parameter names required by some top-level domains.
     * </p>
     * 
     * @return Values corresponding to the additional parameter names required by some top-level domains.
     */
    public String value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nameString());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExtraParam)) {
            return false;
        }
        ExtraParam other = (ExtraParam) obj;
        return Objects.equals(nameString(), other.nameString()) && Objects.equals(value(), other.value());
    }

    @Override
    public String toString() {
        return ToString.builder("ExtraParam").add("Name", nameString()).add("Value", value()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.of(clazz.cast(nameString()));
        case "Value":
            return Optional.of(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ExtraParamMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, ExtraParam> {
        /**
         * <p>
         * Name of the additional parameter required by the top-level domain.
         * </p>
         * 
         * @param name
         *        Name of the additional parameter required by the top-level domain.
         * @see ExtraParamName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExtraParamName
         */
        Builder name(String name);

        /**
         * <p>
         * Name of the additional parameter required by the top-level domain.
         * </p>
         * 
         * @param name
         *        Name of the additional parameter required by the top-level domain.
         * @see ExtraParamName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExtraParamName
         */
        Builder name(ExtraParamName name);

        /**
         * <p>
         * Values corresponding to the additional parameter names required by some top-level domains.
         * </p>
         * 
         * @param value
         *        Values corresponding to the additional parameter names required by some top-level domains.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String value;

        private BuilderImpl() {
        }

        private BuilderImpl(ExtraParam model) {
            name(model.name);
            value(model.value);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public final Builder name(ExtraParamName name) {
            this.name(name.toString());
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getValue() {
            return value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public ExtraParam build() {
            return new ExtraParam(this);
        }
    }
}
