/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53domains.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The ListDomains response includes the following elements.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListDomainsResponse extends Route53DomainsResponse implements
        ToCopyableBuilder<ListDomainsResponse.Builder, ListDomainsResponse> {
    private final List<DomainSummary> domains;

    private final String nextPageMarker;

    private ListDomainsResponse(BuilderImpl builder) {
        super(builder);
        this.domains = builder.domains;
        this.nextPageMarker = builder.nextPageMarker;
    }

    /**
     * <p>
     * A summary of domains.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A summary of domains.
     */
    public List<DomainSummary> domains() {
        return domains;
    }

    /**
     * <p>
     * If there are more domains than you specified for <code>MaxItems</code> in the request, submit another request and
     * include the value of <code>NextPageMarker</code> in the value of <code>Marker</code>.
     * </p>
     * 
     * @return If there are more domains than you specified for <code>MaxItems</code> in the request, submit another
     *         request and include the value of <code>NextPageMarker</code> in the value of <code>Marker</code>.
     */
    public String nextPageMarker() {
        return nextPageMarker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(domains());
        hashCode = 31 * hashCode + Objects.hashCode(nextPageMarker());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDomainsResponse)) {
            return false;
        }
        ListDomainsResponse other = (ListDomainsResponse) obj;
        return Objects.equals(domains(), other.domains()) && Objects.equals(nextPageMarker(), other.nextPageMarker());
    }

    @Override
    public String toString() {
        return ToString.builder("ListDomainsResponse").add("Domains", domains()).add("NextPageMarker", nextPageMarker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Domains":
            return Optional.of(clazz.cast(domains()));
        case "NextPageMarker":
            return Optional.of(clazz.cast(nextPageMarker()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends Route53DomainsResponse.Builder, CopyableBuilder<Builder, ListDomainsResponse> {
        /**
         * <p>
         * A summary of domains.
         * </p>
         * 
         * @param domains
         *        A summary of domains.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domains(Collection<DomainSummary> domains);

        /**
         * <p>
         * A summary of domains.
         * </p>
         * 
         * @param domains
         *        A summary of domains.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domains(DomainSummary... domains);

        /**
         * <p>
         * If there are more domains than you specified for <code>MaxItems</code> in the request, submit another request
         * and include the value of <code>NextPageMarker</code> in the value of <code>Marker</code>.
         * </p>
         * 
         * @param nextPageMarker
         *        If there are more domains than you specified for <code>MaxItems</code> in the request, submit another
         *        request and include the value of <code>NextPageMarker</code> in the value of <code>Marker</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextPageMarker(String nextPageMarker);
    }

    static final class BuilderImpl extends Route53DomainsResponse.BuilderImpl implements Builder {
        private List<DomainSummary> domains;

        private String nextPageMarker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDomainsResponse model) {
            domains(model.domains);
            nextPageMarker(model.nextPageMarker);
        }

        public final Collection<DomainSummary.Builder> getDomains() {
            return domains != null ? domains.stream().map(DomainSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder domains(Collection<DomainSummary> domains) {
            this.domains = DomainSummaryListCopier.copy(domains);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domains(DomainSummary... domains) {
            domains(Arrays.asList(domains));
            return this;
        }

        public final void setDomains(Collection<DomainSummary.BuilderImpl> domains) {
            this.domains = DomainSummaryListCopier.copyFromBuilder(domains);
        }

        public final String getNextPageMarker() {
            return nextPageMarker;
        }

        @Override
        public final Builder nextPageMarker(String nextPageMarker) {
            this.nextPageMarker = nextPageMarker;
            return this;
        }

        public final void setNextPageMarker(String nextPageMarker) {
            this.nextPageMarker = nextPageMarker;
        }

        @Override
        public ListDomainsResponse build() {
            return new ListDomainsResponse(this);
        }
    }
}
