/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53domains.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The UpdateTagsForDomainRequest includes the following elements.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class UpdateTagsForDomainRequest extends Route53DomainsRequest implements
        ToCopyableBuilder<UpdateTagsForDomainRequest.Builder, UpdateTagsForDomainRequest> {
    private final String domainName;

    private final List<Tag> tagsToUpdate;

    private UpdateTagsForDomainRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.tagsToUpdate = builder.tagsToUpdate;
    }

    /**
     * <p>
     * The domain for which you want to add or update tags.
     * </p>
     * 
     * @return The domain for which you want to add or update tags.
     */
    public String domainName() {
        return domainName;
    }

    /**
     * <p>
     * A list of the tag keys and values that you want to add or update. If you specify a key that already exists, the
     * corresponding value will be replaced.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of the tag keys and values that you want to add or update. If you specify a key that already
     *         exists, the corresponding value will be replaced.
     */
    public List<Tag> tagsToUpdate() {
        return tagsToUpdate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(tagsToUpdate());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTagsForDomainRequest)) {
            return false;
        }
        UpdateTagsForDomainRequest other = (UpdateTagsForDomainRequest) obj;
        return Objects.equals(domainName(), other.domainName()) && Objects.equals(tagsToUpdate(), other.tagsToUpdate());
    }

    @Override
    public String toString() {
        return ToString.builder("UpdateTagsForDomainRequest").add("DomainName", domainName()).add("TagsToUpdate", tagsToUpdate())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainName":
            return Optional.of(clazz.cast(domainName()));
        case "TagsToUpdate":
            return Optional.of(clazz.cast(tagsToUpdate()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends Route53DomainsRequest.Builder, CopyableBuilder<Builder, UpdateTagsForDomainRequest> {
        /**
         * <p>
         * The domain for which you want to add or update tags.
         * </p>
         * 
         * @param domainName
         *        The domain for which you want to add or update tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * A list of the tag keys and values that you want to add or update. If you specify a key that already exists,
         * the corresponding value will be replaced.
         * </p>
         * 
         * @param tagsToUpdate
         *        A list of the tag keys and values that you want to add or update. If you specify a key that already
         *        exists, the corresponding value will be replaced.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagsToUpdate(Collection<Tag> tagsToUpdate);

        /**
         * <p>
         * A list of the tag keys and values that you want to add or update. If you specify a key that already exists,
         * the corresponding value will be replaced.
         * </p>
         * 
         * @param tagsToUpdate
         *        A list of the tag keys and values that you want to add or update. If you specify a key that already
         *        exists, the corresponding value will be replaced.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagsToUpdate(Tag... tagsToUpdate);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends Route53DomainsRequest.BuilderImpl implements Builder {
        private String domainName;

        private List<Tag> tagsToUpdate;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTagsForDomainRequest model) {
            domainName(model.domainName);
            tagsToUpdate(model.tagsToUpdate);
        }

        public final String getDomainName() {
            return domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final Collection<Tag.Builder> getTagsToUpdate() {
            return tagsToUpdate != null ? tagsToUpdate.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tagsToUpdate(Collection<Tag> tagsToUpdate) {
            this.tagsToUpdate = TagListCopier.copy(tagsToUpdate);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagsToUpdate(Tag... tagsToUpdate) {
            tagsToUpdate(Arrays.asList(tagsToUpdate));
            return this;
        }

        public final void setTagsToUpdate(Collection<Tag.BuilderImpl> tagsToUpdate) {
            this.tagsToUpdate = TagListCopier.copyFromBuilder(tagsToUpdate);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public UpdateTagsForDomainRequest build() {
            return new UpdateTagsForDomainRequest(this);
        }
    }
}
