/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.services.route53.model.Route53Response;
import software.amazon.awssdk.services.route53.model.VPC;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateVPCAssociationAuthorizationResponse
extends Route53Response
implements ToCopyableBuilder<Builder, CreateVPCAssociationAuthorizationResponse> {
    private final String hostedZoneId;
    private final VPC vpc;

    private CreateVPCAssociationAuthorizationResponse(BuilderImpl builder) {
        super(builder);
        this.hostedZoneId = builder.hostedZoneId;
        this.vpc = builder.vpc;
    }

    public String hostedZoneId() {
        return this.hostedZoneId;
    }

    public VPC vpc() {
        return this.vpc;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hostedZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpc());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVPCAssociationAuthorizationResponse)) {
            return false;
        }
        CreateVPCAssociationAuthorizationResponse other = (CreateVPCAssociationAuthorizationResponse)((Object)obj);
        return Objects.equals(this.hostedZoneId(), other.hostedZoneId()) && Objects.equals(this.vpc(), other.vpc());
    }

    public String toString() {
        return ToString.builder((String)"CreateVPCAssociationAuthorizationResponse").add("HostedZoneId", (Object)this.hostedZoneId()).add("VPC", (Object)this.vpc()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HostedZoneId": {
                return Optional.of(clazz.cast(this.hostedZoneId()));
            }
            case "VPC": {
                return Optional.of(clazz.cast(this.vpc()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends Route53Response.BuilderImpl
    implements Builder {
        private String hostedZoneId;
        private VPC vpc;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVPCAssociationAuthorizationResponse model) {
            this.hostedZoneId(model.hostedZoneId);
            this.vpc(model.vpc);
        }

        public final String getHostedZoneId() {
            return this.hostedZoneId;
        }

        @Override
        public final Builder hostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
            return this;
        }

        public final void setHostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
        }

        public final VPC.Builder getVPC() {
            return this.vpc != null ? this.vpc.toBuilder() : null;
        }

        @Override
        public final Builder vpc(VPC vpc) {
            this.vpc = vpc;
            return this;
        }

        public final void setVPC(VPC.BuilderImpl vpc) {
            this.vpc = vpc != null ? vpc.build() : null;
        }

        @Override
        public CreateVPCAssociationAuthorizationResponse build() {
            return new CreateVPCAssociationAuthorizationResponse(this);
        }
    }

    public static interface Builder
    extends Route53Response.Builder,
    CopyableBuilder<Builder, CreateVPCAssociationAuthorizationResponse> {
        public Builder hostedZoneId(String var1);

        public Builder vpc(VPC var1);

        default public Builder vpc(Consumer<VPC.Builder> vpc) {
            return this.vpc((VPC)((VPC.Builder)VPC.builder().apply(vpc)).build());
        }
    }
}

