/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.route53.model.LinkedService;

public class LinkedServiceUnmarshaller
implements Unmarshaller<LinkedService, StaxUnmarshallerContext> {
    private static final LinkedServiceUnmarshaller INSTANCE = new LinkedServiceUnmarshaller();

    public LinkedService unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        LinkedService.Builder linkedService = LinkedService.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("ServicePrincipal", targetDepth)) {
                    linkedService.servicePrincipal(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Description", targetDepth)) continue;
                linkedService.description(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (LinkedService)linkedService.build();
    }

    public static LinkedServiceUnmarshaller getInstance() {
        return INSTANCE;
    }
}

