/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.route53.model.ResourceRecord;

public class ResourceRecordUnmarshaller
implements Unmarshaller<ResourceRecord, StaxUnmarshallerContext> {
    private static final ResourceRecordUnmarshaller INSTANCE = new ResourceRecordUnmarshaller();

    public ResourceRecord unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        ResourceRecord.Builder resourceRecord = ResourceRecord.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (!context.testExpression("Value", targetDepth)) continue;
                resourceRecord.value(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (ResourceRecord)resourceRecord.build();
    }

    public static ResourceRecordUnmarshaller getInstance() {
        return INSTANCE;
    }
}

